/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row;

import com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling.aggregation.AggregationUnit;
import com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling.aggregation.AggregationUnitFactory;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.AbstractResultSetRow;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GroupBy;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.AggregationSelectItem;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class GroupByResultSetRow
extends AbstractResultSetRow {
    private final ResultSet resultSet;
    private final List<GroupBy> groupByList;
    private final Map<AggregationSelectItem, AggregationUnit> aggregationUnitMap;

    public GroupByResultSetRow(ResultSet resultSet, List<GroupBy> groupByList, List<AggregationSelectItem> aggregationColumns) throws SQLException {
        super(resultSet);
        this.resultSet = resultSet;
        this.groupByList = groupByList;
        this.aggregationUnitMap = Maps.toMap(aggregationColumns, (Function)new Function<AggregationSelectItem, AggregationUnit>(){

            public AggregationUnit apply(AggregationSelectItem input) {
                return AggregationUnitFactory.create(input.getAggregationType());
            }
        });
    }

    public void aggregate() throws SQLException {
        for (Map.Entry<AggregationSelectItem, AggregationUnit> each : this.aggregationUnitMap.entrySet()) {
            each.getValue().merge(this.getAggregationValues(each.getKey().getDerivedAggregationSelectItems().isEmpty() ? Collections.singletonList(each.getKey()) : each.getKey().getDerivedAggregationSelectItems()));
        }
    }

    private List<Comparable<?>> getAggregationValues(List<AggregationSelectItem> aggregationColumns) throws SQLException {
        ArrayList result = new ArrayList(aggregationColumns.size());
        for (AggregationSelectItem each : aggregationColumns) {
            result.add((Comparable)this.resultSet.getObject(each.getColumnIndex()));
        }
        return result;
    }

    public void generateResult() {
        for (AggregationSelectItem each : this.aggregationUnitMap.keySet()) {
            this.setCell(each.getColumnIndex(), this.aggregationUnitMap.get(each).getResult());
        }
    }

    public List<Object> getGroupByValues() throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(this.groupByList.size());
        for (GroupBy each : this.groupByList) {
            result.add(this.resultSet.getObject(each.getColumnIndex()));
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("GroupByKey is: ");
        result.append(Lists.transform(this.groupByList, (Function)new Function<GroupBy, Object>(){

            public Object apply(GroupBy input) {
                return GroupByResultSetRow.this.getCell(input.getColumnIndex());
            }
        }));
        if (this.aggregationUnitMap.isEmpty()) {
            return result.toString();
        }
        result.append("; Aggregation result is: ").append(Lists.transform(new ArrayList<AggregationSelectItem>(this.aggregationUnitMap.keySet()), (Function)new Function<AggregationSelectItem, String>(){

            public String apply(AggregationSelectItem input) {
                Object value = GroupByResultSetRow.this.getCell(input.getColumnIndex());
                value = null == value ? "null" : value;
                return String.format("{index:%d, type:%s, value:%s}", new Object[]{input.getColumnIndex(), input.getAggregationType(), value});
            }
        }));
        return result.toString();
    }
}

