/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling;

import com.dangdang.ddframe.rdb.sharding.merger.resultset.delegate.AbstractDelegateResultSet;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;

public final class LimitCouplingResultSet
extends AbstractDelegateResultSet {
    private final Limit limit;
    private int rowNumber;

    public LimitCouplingResultSet(ResultSet resultSet, SQLStatement sqlStatement) throws SQLException {
        super(Collections.singletonList(resultSet));
        this.limit = sqlStatement.getLimit();
    }

    @Override
    protected boolean firstNext() throws SQLException {
        return this.skipOffset() && this.doNext();
    }

    private boolean skipOffset() throws SQLException {
        for (int i = 0; i < this.limit.getOffset(); ++i) {
            if (this.getDelegate().next()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterFirstNext() throws SQLException {
        return this.doNext();
    }

    private boolean doNext() throws SQLException {
        return ++this.rowNumber <= this.limit.getRowCount() && this.getDelegate().next();
    }
}

