/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling;

import com.dangdang.ddframe.rdb.sharding.merger.ResultSetMergeContext;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.AbstractMemoryResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.GroupByResultSetRow;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.ResultSetRow;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GroupBy;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.AggregationSelectItem;
import com.google.common.base.Optional;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class GroupByCouplingResultSet
extends AbstractMemoryResultSet {
    private final List<GroupBy> groupByList;
    private final List<AggregationSelectItem> aggregationColumns;
    private ResultSet resultSet;
    private boolean hasNext;

    public GroupByCouplingResultSet(ResultSet resultSet, ResultSetMergeContext resultSetMergeContext) throws SQLException {
        super(Collections.singletonList(resultSet));
        this.groupByList = resultSetMergeContext.getSqlStatement().getGroupByList();
        this.aggregationColumns = resultSetMergeContext.getSqlStatement().getAggregationSelectItems();
    }

    @Override
    protected void initRows(List<ResultSet> resultSets) throws SQLException {
        this.resultSet = resultSets.get(0);
        this.hasNext = this.resultSet.next();
    }

    @Override
    protected Optional<? extends ResultSetRow> nextRow() throws SQLException {
        if (!this.hasNext) {
            return Optional.absent();
        }
        GroupByResultSetRow result = new GroupByResultSetRow(this.resultSet, this.groupByList, this.aggregationColumns);
        List<Object> groupByValues = result.getGroupByValues();
        while (this.hasNext && (this.groupByList.isEmpty() || groupByValues.equals(result.getGroupByValues()))) {
            result.aggregate();
            this.hasNext = this.resultSet.next();
        }
        result.generateResult();
        return Optional.of((Object)result);
    }
}

