/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger;

import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractResultSetAdapter;
import com.dangdang.ddframe.rdb.sharding.merger.ShardingResultSets;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GroupBy;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.IndexColumn;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.OrderBy;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.AggregationSelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ResultSetMergeContext {
    private final ShardingResultSets shardingResultSets;
    private final SQLStatement sqlStatement;
    private final List<OrderBy> currentOrderByKeys;

    public ResultSetMergeContext(ShardingResultSets shardingResultSets, SQLStatement sqlStatement) {
        this.shardingResultSets = shardingResultSets;
        this.sqlStatement = sqlStatement;
        this.currentOrderByKeys = new LinkedList<OrderBy>();
        this.init();
    }

    private void init() {
        this.setColumnIndex(((AbstractResultSetAdapter)this.shardingResultSets.getResultSets().get(0)).getColumnLabelIndexMap());
        this.currentOrderByKeys.addAll(this.sqlStatement.getOrderByList());
    }

    private void setColumnIndex(Map<String, Integer> columnLabelIndexMap) {
        for (IndexColumn each : this.getAllFocusedColumns()) {
            if (each.getColumnIndex() > 0) continue;
            Preconditions.checkState((columnLabelIndexMap.containsKey(each.getColumnLabel().orNull()) || columnLabelIndexMap.containsKey(each.getColumnName().orNull()) ? 1 : 0) != 0, (Object)String.format("%s has not index", each));
            if (each.getColumnLabel().isPresent() && columnLabelIndexMap.containsKey(each.getColumnLabel().get())) {
                each.setColumnIndex(columnLabelIndexMap.get(each.getColumnLabel().get()));
                continue;
            }
            if (!each.getColumnName().isPresent() || !columnLabelIndexMap.containsKey(each.getColumnName().get())) continue;
            each.setColumnIndex(columnLabelIndexMap.get(each.getColumnName().get()));
        }
    }

    private List<IndexColumn> getAllFocusedColumns() {
        LinkedList<IndexColumn> result = new LinkedList<IndexColumn>();
        result.addAll(this.sqlStatement.getGroupByList());
        result.addAll(this.sqlStatement.getOrderByList());
        LinkedList allAggregationColumns = Lists.newLinkedList(this.sqlStatement.getAggregationSelectItems());
        while (!allAggregationColumns.isEmpty()) {
            AggregationSelectItem firstElement = (AggregationSelectItem)allAggregationColumns.poll();
            result.add(firstElement);
            if (firstElement.getDerivedAggregationSelectItems().isEmpty()) continue;
            allAggregationColumns.addAll(firstElement.getDerivedAggregationSelectItems());
        }
        return result;
    }

    public boolean isNeedMemorySortForGroupBy() {
        return !this.sqlStatement.getGroupByList().isEmpty() && !this.currentOrderByKeys.equals(this.transformGroupByColumnsToOrderByColumns());
    }

    public void setGroupByKeysToCurrentOrderByKeys() {
        this.currentOrderByKeys.clear();
        this.currentOrderByKeys.addAll(this.transformGroupByColumnsToOrderByColumns());
    }

    private List<OrderBy> transformGroupByColumnsToOrderByColumns() {
        return Lists.transform(this.sqlStatement.getGroupByList(), (Function)new Function<GroupBy, OrderBy>(){

            public OrderBy apply(GroupBy input) {
                OrderBy result = input.getOwner().isPresent() ? new OrderBy((String)input.getOwner().get(), input.getName(), input.getOrderByType(), input.getAlias()) : new OrderBy(input.getName(), input.getOrderByType(), input.getAlias());
                result.setColumnIndex(input.getColumnIndex());
                return result;
            }
        });
    }

    public boolean isNeedMemorySortForOrderBy() {
        return !this.sqlStatement.getOrderByList().isEmpty() && !this.currentOrderByKeys.equals(this.sqlStatement.getOrderByList());
    }

    public void setOrderByKeysToCurrentOrderByKeys() {
        this.currentOrderByKeys.clear();
        this.currentOrderByKeys.addAll(this.sqlStatement.getOrderByList());
    }

    public ShardingResultSets getShardingResultSets() {
        return this.shardingResultSets;
    }

    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    public List<OrderBy> getCurrentOrderByKeys() {
        return this.currentOrderByKeys;
    }
}

