/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger;

import com.dangdang.ddframe.rdb.sharding.merger.ResultSetMergeContext;
import com.dangdang.ddframe.rdb.sharding.merger.ShardingResultSets;
import com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling.GroupByCouplingResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling.LimitCouplingResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling.MemoryOrderByCouplingResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.pipeline.reducer.IteratorReducerResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.pipeline.reducer.MemoryOrderByReducerResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.pipeline.reducer.StreamingOrderByReducerResultSet;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResultSetFactory {
    private static final Logger log = LoggerFactory.getLogger(ResultSetFactory.class);

    public static ResultSet getResultSet(List<ResultSet> resultSets, SQLStatement sqlStatement) throws SQLException {
        ShardingResultSets shardingResultSets = new ShardingResultSets(resultSets);
        log.debug("Sharding-JDBC: Sharding result sets type is '{}'", (Object)shardingResultSets.getType().toString());
        switch (shardingResultSets.getType()) {
            case EMPTY: {
                return ResultSetFactory.buildEmpty(resultSets);
            }
            case SINGLE: {
                return ResultSetFactory.buildSingle(shardingResultSets);
            }
            case MULTIPLE: {
                return ResultSetFactory.buildMultiple(shardingResultSets, sqlStatement);
            }
        }
        throw new UnsupportedOperationException(shardingResultSets.getType().toString());
    }

    private static ResultSet buildEmpty(List<ResultSet> resultSets) {
        return resultSets.get(0);
    }

    private static ResultSet buildSingle(ShardingResultSets shardingResultSets) {
        return shardingResultSets.getResultSets().get(0);
    }

    private static ResultSet buildMultiple(ShardingResultSets shardingResultSets, SQLStatement sqlStatement) throws SQLException {
        ResultSetMergeContext resultSetMergeContext = new ResultSetMergeContext(shardingResultSets, sqlStatement);
        return ResultSetFactory.buildCoupling(ResultSetFactory.buildReducer(resultSetMergeContext), resultSetMergeContext);
    }

    private static ResultSet buildReducer(ResultSetMergeContext resultSetMergeContext) throws SQLException {
        if (resultSetMergeContext.isNeedMemorySortForGroupBy()) {
            resultSetMergeContext.setGroupByKeysToCurrentOrderByKeys();
            return new MemoryOrderByReducerResultSet(resultSetMergeContext);
        }
        if (!resultSetMergeContext.getSqlStatement().getGroupByList().isEmpty() || !resultSetMergeContext.getSqlStatement().getOrderByList().isEmpty()) {
            return new StreamingOrderByReducerResultSet(resultSetMergeContext);
        }
        return new IteratorReducerResultSet(resultSetMergeContext);
    }

    private static ResultSet buildCoupling(ResultSet resultSet, ResultSetMergeContext resultSetMergeContext) throws SQLException {
        ResultSet result = resultSet;
        if (!resultSetMergeContext.getSqlStatement().getGroupByList().isEmpty() || !resultSetMergeContext.getSqlStatement().getAggregationSelectItems().isEmpty()) {
            result = new GroupByCouplingResultSet(result, resultSetMergeContext);
        }
        if (resultSetMergeContext.isNeedMemorySortForOrderBy()) {
            resultSetMergeContext.setOrderByKeysToCurrentOrderByKeys();
            result = new MemoryOrderByCouplingResultSet(result, resultSetMergeContext);
        }
        if (null != resultSetMergeContext.getSqlStatement().getLimit()) {
            result = new LimitCouplingResultSet(result, resultSetMergeContext.getSqlStatement());
        }
        return result;
    }

    private ResultSetFactory() {
    }
}

