/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.statement;

import com.dangdang.ddframe.rdb.sharding.executor.type.statement.StatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.type.statement.StatementUnit;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset.GeneratedKeysResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.ResultSetFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GeneratedKey;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.routing.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.routing.SQLRouteResult;
import com.dangdang.ddframe.rdb.sharding.routing.StatementRoutingEngine;
import com.google.common.base.Optional;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class ShardingStatement
extends AbstractStatementAdapter {
    private final ShardingConnection shardingConnection;
    private boolean returnGeneratedKeys;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final Collection<Statement> routedStatements = new LinkedList<Statement>();
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingStatement(ShardingConnection shardingConnection) {
        this(shardingConnection, 1003, 1007, 1);
    }

    public ShardingStatement(ShardingConnection shardingConnection, int resultSetType, int resultSetConcurrency) {
        this(shardingConnection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingStatement(ShardingConnection shardingConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.shardingConnection = shardingConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.shardingConnection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet result;
        try {
            result = ResultSetFactory.getResultSet(this.generateExecutor(sql).executeQuery(), this.routeResult.getSqlStatement());
        }
        finally {
            this.setCurrentResultSet(null);
        }
        this.setCurrentResultSet(result);
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            int n = this.generateExecutor(sql).executeUpdate();
            return n;
        }
        finally {
            this.setCurrentResultSet(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.markReturnGeneratedKeys();
        }
        try {
            int n = this.generateExecutor(sql).executeUpdate(autoGeneratedKeys);
            return n;
        }
        finally {
            this.setCurrentResultSet(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.markReturnGeneratedKeys();
        try {
            int n = this.generateExecutor(sql).executeUpdate(columnIndexes);
            return n;
        }
        finally {
            this.setCurrentResultSet(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.markReturnGeneratedKeys();
        try {
            int n = this.generateExecutor(sql).executeUpdate(columnNames);
            return n;
        }
        finally {
            this.setCurrentResultSet(null);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            boolean bl = this.generateExecutor(sql).execute();
            return bl;
        }
        finally {
            this.setCurrentResultSet(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.markReturnGeneratedKeys();
        }
        try {
            boolean bl = this.generateExecutor(sql).execute(autoGeneratedKeys);
            return bl;
        }
        finally {
            this.setCurrentResultSet(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.markReturnGeneratedKeys();
        try {
            boolean bl = this.generateExecutor(sql).execute(columnIndexes);
            return bl;
        }
        finally {
            this.setCurrentResultSet(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.markReturnGeneratedKeys();
        try {
            boolean bl = this.generateExecutor(sql).execute(columnNames);
            return bl;
        }
        finally {
            this.setCurrentResultSet(null);
        }
    }

    protected final void markReturnGeneratedKeys() {
        this.returnGeneratedKeys = true;
    }

    private StatementExecutor generateExecutor(String sql) throws SQLException {
        this.clearPrevious();
        this.routeResult = new StatementRoutingEngine(this.shardingConnection.getShardingContext()).route(sql);
        LinkedList<StatementUnit> statementUnits = new LinkedList<StatementUnit>();
        for (SQLExecutionUnit each : this.routeResult.getExecutionUnits()) {
            Statement statement = this.shardingConnection.getConnection(each.getDataSource(), this.routeResult.getSqlStatement().getType()).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.replayMethodsInvocation(statement);
            statementUnits.add(new StatementUnit(each, statement));
            this.routedStatements.add(statement);
        }
        return new StatementExecutor(this.shardingConnection.getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), statementUnits);
    }

    private void clearPrevious() throws SQLException {
        for (Statement each : this.routedStatements) {
            each.close();
        }
        this.routedStatements.clear();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (generatedKey.isPresent() && this.returnGeneratedKeys) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn(), this);
        }
        return new GeneratedKeysResultSet();
    }

    protected final Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)((InsertStatement)this.routeResult.getSqlStatement()).getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.routedStatements.size()) {
            this.currentResultSet = this.routedStatements.iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.routedStatements.size());
        for (Statement each : this.routedStatements) {
            resultSets.add(each.getResultSet());
        }
        this.currentResultSet = ResultSetFactory.getResultSet(resultSets, this.routeResult.getSqlStatement());
        return this.currentResultSet;
    }

    protected ShardingConnection getShardingConnection() {
        return this.shardingConnection;
    }

    protected boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Collection<Statement> getRoutedStatements() {
        return this.routedStatements;
    }

    protected SQLRouteResult getRouteResult() {
        return this.routeResult;
    }

    protected void setRouteResult(SQLRouteResult routeResult) {
        this.routeResult = routeResult;
    }

    protected void setCurrentResultSet(ResultSet currentResultSet) {
        this.currentResultSet = currentResultSet;
    }
}

