/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.adapter;

import com.dangdang.ddframe.rdb.sharding.jdbc.unsupported.AbstractUnsupportedOperationResultSet;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultSetAdapter
extends AbstractUnsupportedOperationResultSet {
    private static final Logger log = LoggerFactory.getLogger(AbstractResultSetAdapter.class);
    private final List<ResultSet> resultSets;
    private final Map<String, Integer> columnLabelIndexMap;
    private boolean closed;

    public AbstractResultSetAdapter(List<ResultSet> resultSets) throws SQLException {
        Preconditions.checkArgument((!resultSets.isEmpty() ? 1 : 0) != 0);
        this.resultSets = resultSets;
        this.columnLabelIndexMap = this.generateColumnLabelIndexMap();
    }

    private Map<String, Integer> generateColumnLabelIndexMap() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.resultSets.get(0).getMetaData();
        CaseInsensitiveMap result = new CaseInsensitiveMap(resultSetMetaData.getColumnCount());
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            result.put(resultSetMetaData.getColumnLabel(i), i);
        }
        return result;
    }

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (ResultSet each : this.resultSets) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNessesary(exceptions);
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        for (ResultSet each : this.resultSets) {
            each.setFetchDirection(direction);
        }
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        for (ResultSet each : this.resultSets) {
            each.setFetchSize(rows);
        }
    }

    public List<ResultSet> getResultSets() {
        return this.resultSets;
    }

    public Map<String, Integer> getColumnLabelIndexMap() {
        return this.columnLabelIndexMap;
    }
}

