/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor.type.batch;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.executor.BaseStatementUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteCallback;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.executor.type.batch.BatchPreparedStatementUnit;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class BatchPreparedStatementExecutor {
    private final ExecutorEngine executorEngine;
    private final SQLType sqlType;
    private final Collection<BatchPreparedStatementUnit> batchPreparedStatementUnits;
    private final List<List<Object>> parameterSets;

    public int[] executeBatch() {
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-executeBatch");
        try {
            int[] nArray = this.accumulate(this.executorEngine.executeBatch(this.sqlType, this.batchPreparedStatementUnits, this.parameterSets, new ExecuteCallback<int[]>(){

                @Override
                public int[] execute(BaseStatementUnit baseStatementUnit) throws Exception {
                    return baseStatementUnit.getStatement().executeBatch();
                }
            }));
            return nArray;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private int[] accumulate(List<int[]> results) {
        int[] result = new int[this.parameterSets.size()];
        int count = 0;
        for (BatchPreparedStatementUnit each : this.batchPreparedStatementUnits) {
            for (Map.Entry<Integer, Integer> entry : each.getOuterAndInnerAddBatchCountMap().entrySet()) {
                int n = entry.getKey();
                result[n] = result[n] + (null == results.get(count) ? 0 : results.get(count)[entry.getValue()]);
            }
            ++count;
        }
        return result;
    }

    @ConstructorProperties(value={"executorEngine", "sqlType", "batchPreparedStatementUnits", "parameterSets"})
    public BatchPreparedStatementExecutor(ExecutorEngine executorEngine, SQLType sqlType, Collection<BatchPreparedStatementUnit> batchPreparedStatementUnits, List<List<Object>> parameterSets) {
        this.executorEngine = executorEngine;
        this.sqlType = sqlType;
        this.batchPreparedStatementUnits = batchPreparedStatementUnits;
        this.parameterSets = parameterSets;
    }
}

