/*
 * Copyright 1999-2015 dangdang.com.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * </p>
 */

package com.dangdang.ddframe.rdb.sharding.parser.result;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 自动生成键上下文.
 * 
 * @author gaohongtao
 */
@ToString
public class GeneratedKeyContext {
    
    @Getter
    private final List<String> columns = new LinkedList<>();
    
    @Getter
    private final Map<String, Integer> columnNameToIndexMap = new HashMap<>();
    
    @Getter
    private final Table<Integer, Integer, Object> valueTable = TreeBasedTable.create();
    
    private int rowIndex;
    
    private int columnIndex;
    
    @Setter
    @Getter
    private int autoGeneratedKeys;
    
    @Setter
    @Getter
    private int[] columnIndexes;
    
    @Setter
    @Getter
    private String[] columnNames;
    
    /**
     * 放入生成的键值.
     * 
     * @param columnName 列名称
     * @param value 键值
     */
    public void putValue(final String columnName, final Object value) {
        valueTable.put(rowIndex, columnIndex, value);
        columnNameToIndexMap.put(columnName, columnIndex);
        columnIndex++;
    }
    
    /**
     * 结果集增加一行.
     */
    public void addRow() {
        rowIndex++;
        columnIndex = 0;
    }
}
