/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class UnionIterator
extends NodeIterator {
    private NodeIterator _leftIter;
    private NodeIterator _rightIter;
    private Node _node;

    public UnionIterator(ExprEnvironment env, NodeIterator leftIter, NodeIterator rightIter) throws XPathException {
        super(env);
        this._leftIter = leftIter;
        this._rightIter = rightIter;
        this._node = leftIter.nextNode();
        if (this._node == null) {
            this._leftIter = null;
            this._node = this._rightIter.nextNode();
        }
    }

    public boolean hasNext() {
        return this._node != null;
    }

    public Node nextNode() throws XPathException {
        Node next = this._node;
        if (next == null) {
            return null;
        }
        if (this._leftIter != null) {
            this._node = this._leftIter.nextNode();
            if (this._node == null) {
                this._leftIter = null;
                this._node = this._rightIter.nextNode();
            }
        } else {
            this._node = this._rightIter.nextNode();
        }
        return next;
    }

    public Object clone() {
        try {
            UnionIterator clone = new UnionIterator(this._env, (NodeIterator)this._leftIter.clone(), (NodeIterator)this._rightIter.clone());
            clone._node = this._node;
            clone._position = this._position;
            return clone;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }
}

