/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class AxisIterator
extends NodeIterator {
    protected NodeIterator _parentIter;
    protected AbstractPattern _axis;
    protected Node _node;
    protected Node _next;
    protected Node _lastNode;
    protected AbstractPattern _match;

    protected AxisIterator(ExprEnvironment env) {
        super(env);
    }

    public AxisIterator(NodeIterator parentIter, AbstractPattern axis, Node node, ExprEnvironment env, AbstractPattern match) throws XPathException {
        super(env);
        this._parentIter = parentIter;
        this._axis = axis;
        this._match = match;
        if (parentIter != null) {
            node = parentIter.nextNode();
        }
        if (node != null) {
            this._lastNode = axis.lastNode(node);
            this._node = this.findFirstMatchingNode(axis.firstNode(node, this._env));
        }
        this._next = this._node;
    }

    public boolean hasNext() {
        if (this._next == null) {
            try {
                this._next = this.nextNode();
            }
            catch (XPathException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._next != null;
    }

    public Node nextNode() throws XPathException {
        if (this._next != null) {
            this._node = this._next;
            this._next = null;
            return this._node;
        }
        if (this._node != null) {
            this._node = this.findFirstMatchingNode(this._axis.nextNode(this._node, this._lastNode));
        }
        this._next = null;
        return this._node;
    }

    private Node findFirstMatchingNode(Node node) throws XPathException {
        while (true) {
            if (node != null) {
                if (this._match == null || this._match.match(node, this._env)) {
                    ++this._position;
                    return node;
                }
                node = this._axis.nextNode(node, this._lastNode);
                continue;
            }
            if (this._parentIter == null || (node = this._parentIter.nextNode()) == null) {
                return null;
            }
            this._position = 0;
            this._size = 0;
            this._lastNode = this._axis.lastNode(node);
            node = this._axis.firstNode(node, this._env);
        }
    }

    public int getContextSize() {
        if (this._size == 0) {
            this._size = this._position;
            try {
                Node ptr;
                Node node = ptr = this._node == null ? null : this._axis.nextNode(this._node, this._lastNode);
                while (ptr != null) {
                    if (this._match == null || this._match.match(ptr, this._env)) {
                        ++this._size;
                    }
                    ptr = this._axis.nextNode(ptr, this._lastNode);
                }
            }
            catch (XPathException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._size;
    }

    public Object clone() {
        AxisIterator iter = new AxisIterator(this._env);
        iter.copy(this);
        if (this._parentIter != null) {
            iter._parentIter = (NodeIterator)this._parentIter.clone();
        }
        iter._axis = this._axis;
        iter._node = this._node;
        iter._match = this._match;
        return iter;
    }

    public String toString() {
        return "AxisIterator[axis:" + this._axis + ",match:" + this._match + "]";
    }
}

