/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class ObjectJavaExpr
extends Expr {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/xpath/expr/ObjectJavaExpr"));
    private static final int J_BOOLEAN = 1;
    private static final int J_BYTE = 2;
    private static final int J_SHORT = 3;
    private static final int J_INT = 4;
    private static final int J_LONG = 5;
    private static final int J_FLOAT = 6;
    private static final int J_DOUBLE = 7;
    private static final int J_STRING = 8;
    private static final int J_OBJECT = 9;
    private Method method;
    private Expr objArg;
    private ArrayList args;
    private int[] argTypes;
    private int retType;

    public ObjectJavaExpr(Method method, Expr objArg, ArrayList args) {
        this.method = method;
        this.objArg = objArg;
        this.args = args;
        this.argTypes = new int[args.size()];
        Class<?>[] paramClasses = method.getParameterTypes();
        for (int i = 0; i < paramClasses.length; ++i) {
            this.argTypes[i] = this.classToType(paramClasses[i]);
        }
        this.retType = this.classToType(method.getReturnType());
    }

    private int classToType(Class cl) {
        if (Boolean.TYPE.equals(cl) || ClassLiteral.getClass((String)"java/lang/Boolean").equals(cl)) {
            return 1;
        }
        if (Byte.TYPE.equals(cl) || ClassLiteral.getClass((String)"java/lang/Byte").equals(cl)) {
            return 2;
        }
        if (Short.TYPE.equals(cl) || ClassLiteral.getClass((String)"java/lang/Short").equals(cl)) {
            return 3;
        }
        if (Integer.TYPE.equals(cl) || ClassLiteral.getClass((String)"java/lang/Integer").equals(cl)) {
            return 4;
        }
        if (Long.TYPE.equals(cl) || ClassLiteral.getClass((String)"java/lang/Long").equals(cl)) {
            return 5;
        }
        if (Float.TYPE.equals(cl) || ClassLiteral.getClass((String)"java/lang/Float").equals(cl)) {
            return 6;
        }
        if (Double.TYPE.equals(cl) || ClassLiteral.getClass((String)"java/lang/Double").equals(cl)) {
            return 7;
        }
        if (ClassLiteral.getClass((String)"java/lang/String").equals(cl)) {
            return 8;
        }
        return 9;
    }

    public boolean isString() {
        return this.retType == 8;
    }

    public boolean isBoolean() {
        return this.retType == 1;
    }

    public boolean isNumber() {
        return this.retType >= 2 && this.retType <= 7;
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        Object value = this.evalObject(node, env);
        return String.valueOf(value);
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        return ObjectJavaExpr.toBoolean(this.evalObject(node, env));
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        return ObjectJavaExpr.toDouble(this.evalObject(node, env));
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        Object[] argArray = new Object[this.args.size()];
        Object obj = this.objArg.evalObject(node, env);
        if (obj == null || !this.method.getDeclaringClass().isAssignableFrom(obj.getClass())) {
            throw new XPathException(L.l("Can't call method `{0}' on {1}.", (Object)this.method.getName(), obj));
        }
        block12: for (int i = 0; i < argArray.length; ++i) {
            Expr expr = (Expr)this.args.get(i);
            switch (this.argTypes[i]) {
                case 1: {
                    argArray[i] = new Boolean(expr.evalBoolean(node, env));
                    continue block12;
                }
                case 2: {
                    argArray[i] = new Byte((byte)expr.evalNumber(node, env));
                    continue block12;
                }
                case 3: {
                    argArray[i] = new Short((short)expr.evalNumber(node, env));
                    continue block12;
                }
                case 4: {
                    argArray[i] = new Integer((int)expr.evalNumber(node, env));
                    continue block12;
                }
                case 5: {
                    argArray[i] = new Long((long)expr.evalNumber(node, env));
                    continue block12;
                }
                case 6: {
                    argArray[i] = new Float((float)expr.evalNumber(node, env));
                    continue block12;
                }
                case 7: {
                    argArray[i] = new Double(expr.evalNumber(node, env));
                    continue block12;
                }
                case 8: {
                    argArray[i] = expr.evalString(node, env);
                    continue block12;
                }
                default: {
                    argArray[i] = expr.evalObject(node, env);
                }
            }
        }
        try {
            return this.method.invoke(obj, argArray);
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("java:");
        cb.append(this.method.getDeclaringClass().getName());
        cb.append(".");
        cb.append(this.method.getName());
        cb.append("(");
        cb.append(this.objArg);
        for (int i = 0; i < this.args.size(); ++i) {
            cb.append(",");
            cb.append(this.args.get(i));
        }
        cb.append(")");
        return cb.close();
    }
}

