/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.readers;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.XmlParser;
import com.caucho.xml.readers.XmlReader;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;

public class Utf8Reader
extends XmlReader {
    public Utf8Reader() {
    }

    public Utf8Reader(XmlParser parser, ReadStream is) {
        super(parser, is);
    }

    public int read() throws IOException {
        int ch1 = this._is.read();
        if (ch1 == 10) {
            this._parser.setLine(++this._line);
            return ch1;
        }
        if (ch1 == 13) {
            this._parser.setLine(++this._line);
            int ch2 = this._is.read();
            if (ch2 == 10) {
                return 10;
            }
            if (ch2 >= 0) {
                if (ch2 < 128) {
                    this._parser.unread(ch2);
                } else {
                    this._parser.unread(this.readSecond(ch2));
                }
            }
            return 10;
        }
        if (ch1 < 128) {
            return ch1;
        }
        return this.readSecond(ch1);
    }

    private int readSecond(int ch1) throws IOException {
        if ((ch1 & 0xE0) == 192) {
            int ch2 = this._is.read();
            if (ch2 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch2 & 0xC0) != 128) {
                throw this.error(L.l("illegal utf8 encoding {0}", this.hex(ch1)));
            }
            return ((ch1 & 0x1F) << 6) + (ch2 & 0x3F);
        }
        if ((ch1 & 0xF0) == 224) {
            int ch2 = this._is.read();
            int ch3 = this._is.read();
            if (ch2 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch2 & 0xC0) != 128) {
                throw this.error(L.l("illegal utf8 encoding at {0} {1} {2}", this.hex(ch1), this.hex(ch2), this.hex(ch3)));
            }
            if (ch3 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch3 & 0xC0) != 128) {
                throw this.error(L.l("illegal utf8 encoding {0} {1} {2}", this.hex(ch1), this.hex(ch2), this.hex(ch3)));
            }
            int ch = ((ch1 & 0x1F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F);
            if (ch == 65279) {
                return this.read();
            }
            return ch;
        }
        throw this.error(L.l("illegal utf8 encoding at {0}", this.hex(ch1)));
    }

    private String hex(int n) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("0x");
        int d = (n &= 0xFF) / 16;
        if (d >= 0 && d <= 9) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
        d = n % 16;
        if (d >= 0 && d <= 9) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
        return cb.close();
    }

    private CharConversionException error(String msg) {
        String filename = this._parser.getFilename();
        int line = this._parser.getLine();
        if (filename != null) {
            return new CharConversionException(filename + ":" + line + ": " + msg);
        }
        return new CharConversionException(msg);
    }
}

