/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QAttributedNode;
import com.caucho.xml.QDeepNodeList;
import com.caucho.xml.QName;
import com.caucho.xml.QNodePredicate;
import com.caucho.xml.SerializedXml;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class QElement
extends QAttributedNode
implements CauchoElement {
    private QName _name;

    QElement() {
    }

    QElement(QName name) {
        this._name = name;
    }

    QElement(QName name, HashMap attributes) {
        this._name = name;
    }

    public void setName(QName name) {
        this._name = name;
    }

    public QName getQName() {
        return this._name;
    }

    public String getNodeName() {
        return this._name.getName();
    }

    public String getTagName() {
        return this._name.getName();
    }

    public String getLocalName() {
        return this._name.getLocalName();
    }

    public String getPrefix() {
        return this._name.getPrefix();
    }

    public String getCanonicalName() {
        return this._name.getCanonicalName();
    }

    public String getNamespaceURI() {
        return this._name.getNamespace();
    }

    public String getNamespace(String prefix) {
        if (prefix == null) {
            return this.getNamespace("", "xmlns");
        }
        return this.getNamespace(prefix, "xmlns:" + prefix);
    }

    private String getNamespace(String prefix, String xmlns) {
        Attr namespace = this.getAttributeNode(xmlns);
        if (namespace != null) {
            return namespace.getNodeValue();
        }
        if (this._parent instanceof QElement) {
            return ((QElement)this._parent).getNamespace(prefix, xmlns);
        }
        return this._owner.getNamespace(prefix);
    }

    public short getNodeType() {
        return 1;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public NodeList getElementsByTagName(String tagName) {
        QAbstractNode child = (QAbstractNode)this.getFirstChild();
        if (child != null) {
            return new QDeepNodeList(this, child, new TagPredicate(tagName));
        }
        return new QDeepNodeList(this, null, new TagPredicate(tagName));
    }

    public NodeList getElementsByTagNameNS(String uri, String name) {
        QAbstractNode child = (QAbstractNode)this.getFirstChild();
        if (child != null) {
            return new QDeepNodeList(this, child, new NSTagPredicate(uri, name));
        }
        return new QDeepNodeList(this, null, new NSTagPredicate(uri, name));
    }

    public Node appendChild(Node child) throws DOMException {
        Node result = super.appendChild(child);
        if (child instanceof QElement) {
            QElement elt = (QElement)child;
            QName name = elt._name;
            if (name.getNamespace() != "") {
                this.addNamespace(name);
            }
        }
        return result;
    }

    void addNamespace(QName name) {
        this._owner.addNamespace(name.getPrefix(), name.getNamespace());
    }

    public void normalize() {
        Node node = this._firstChild;
        while (node != null) {
            if (node.getNodeType() == 3 && node.getNextSibling() != null && node.getNextSibling().getNodeType() == 3) {
                Text text = (Text)node;
                Text next = (Text)node.getNextSibling();
                text.appendData(next.getData());
                this.removeChild(next);
                continue;
            }
            if (node.getNodeType() == 1) {
                Element elt = (Element)node;
                elt.normalize();
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
    }

    public boolean hasContent() {
        return true;
    }

    public boolean equals(Object arg) {
        return this == arg;
    }

    public boolean equals(Node arg, boolean deep) {
        return this == arg;
    }

    public String getTextValue() {
        CharBuffer cb = CharBuffer.allocate();
        QAbstractNode node = this._firstChild;
        while (node != null) {
            cb.append(node.getTextValue());
            node = node._next;
        }
        return cb.close();
    }

    void print(XmlPrinter out) throws IOException {
        Node node;
        out.startElement(this.getNamespaceURI(), this.getLocalName(), this.getNodeName());
        for (node = (QAbstractNode)((Object)this.getFirstAttribute()); node != null; node = (QAbstractNode)((QAbstractNode)node).getNextSibling()) {
            out.attribute(((QAbstractNode)node).getNamespaceURI(), ((QAbstractNode)node).getLocalName(), node.getNodeName(), ((QAbstractNode)node).getNodeValue());
        }
        for (node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ((QAbstractNode)node).print(out);
        }
        out.endElement(this.getNamespaceURI(), this.getLocalName(), this.getNodeName());
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("Element[" + this._name);
        for (QAttr attr = (QAttr)this.getFirstAttribute(); attr != null; attr = (QAttr)attr.getNextSibling()) {
            cb.append(" " + attr);
        }
        cb.append("]");
        return cb.close();
    }

    private Object writeReplace() {
        return new SerializedXml(this);
    }

    static class NSTagPredicate
    implements QNodePredicate {
        String _uri;
        String _local;

        NSTagPredicate(String uri, String local) {
            this._uri = uri;
            this._local = local;
        }

        public boolean isMatch(QAbstractNode node) {
            return this._local.equals(node.getLocalName()) && this._uri.equals(node.getNamespaceURI());
        }
    }

    static class TagPredicate
    implements QNodePredicate {
        String _name;

        TagPredicate(String name) {
            if (name == null) {
                name = "*";
            }
            this._name = name;
        }

        public boolean isMatch(QAbstractNode node) {
            return node.getNodeName().equals(this._name) || this._name.equals("*") && node instanceof Element;
        }
    }
}

