/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QElement;
import com.caucho.xml.QElementDef;
import com.caucho.xml.QEntity;
import com.caucho.xml.QNamedNodeMap;
import com.caucho.xml.QNode;
import com.caucho.xml.QNotation;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QDocumentType
extends QNode
implements DocumentType {
    String _name;
    HashMap<String, QElementDef> _elements = new HashMap();
    HashMap<String, QEntity> _entities = new HashMap();
    HashMap<String, QNotation> _notations = new HashMap();
    HashMap<String, QEntity> _parameterEntities = new HashMap();
    HashMap<String, String> _ids = new HashMap();
    String _systemId;
    String _publicId;
    boolean _hasAttributeDefaults;

    public QDocumentType(String name) {
        this._name = name;
        this._entities.put("amp", new QEntity("amp", "&"));
        this._entities.put("lt", new QEntity("lt", "<"));
        this._entities.put("gt", new QEntity("gt", ">"));
        this._entities.put("quot", new QEntity("quot", "\""));
        this._entities.put("apos", new QEntity("apos", "'"));
    }

    public String getNodeName() {
        return "#documenttype";
    }

    public String getTagName() {
        return "#documenttype";
    }

    public short getNodeType() {
        return 10;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public NamedNodeMap getEntities() {
        return new QNamedNodeMap(this._entities);
    }

    public NamedNodeMap getNotations() {
        return new QNamedNodeMap(this._notations);
    }

    public void setLocation(String filename, int line, int col) {
    }

    Node importNode(QDocument owner, boolean deep) {
        QDocumentType ref = new QDocumentType(this._name);
        return ref;
    }

    void addNotation(QNotation notation) {
        this._notations.put(notation._name, notation);
    }

    public String getElementId(String element) {
        return this._ids.get(element);
    }

    public Iterator getElementIdNames() {
        return this._ids.keySet().iterator();
    }

    void setElementId(String element, String id) {
        this._ids.put(element, id);
    }

    void addEntity(QEntity entity) {
        if (this._entities.get(entity._name) == null) {
            this._entities.put(entity._name, entity);
        }
    }

    QEntity getEntity(String name) {
        return this._entities.get(name);
    }

    void addParameterEntity(QEntity entity) {
        if (this._parameterEntities.get(entity._name) == null) {
            this._parameterEntities.put(entity._name, entity);
        }
    }

    QEntity getParameterEntity(String name) {
        return this._parameterEntities.get(name);
    }

    String getEntityValue(String name) {
        QEntity entity = this._entities.get(name);
        if (entity == null) {
            return null;
        }
        return entity._value;
    }

    public String getSystemId() {
        return this._systemId;
    }

    void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    public String getPublicId() {
        return this._publicId;
    }

    void setPublicId(String publicId) {
        this._publicId = publicId;
    }

    public String getInternalSubset() {
        return null;
    }

    boolean isExternal() {
        return this._systemId != null || this._publicId != null;
    }

    public QElementDef getElement(String name) {
        return this._elements.get(name);
    }

    QElementDef addElement(String name) {
        QElementDef def = this._elements.get(name);
        if (def == null) {
            def = new QElementDef(name);
            def._dtd = this;
            def._owner = this._owner;
            this._elements.put(name, def);
            this.appendChild(def);
        }
        return def;
    }

    void setAttributeDefaults() {
        this._hasAttributeDefaults = true;
    }

    boolean hasAttributeDefaults() {
        return this._hasAttributeDefaults;
    }

    void fillDefaults(QElement element) {
        if (!this._hasAttributeDefaults) {
            return;
        }
        QElementDef def = this.getElement(element.getNodeName());
        if (def != null) {
            def.fillDefaults(element);
        }
    }

    void print(XmlPrinter os) throws IOException {
        if (this.getName() == null) {
            return;
        }
        os.print("<!DOCTYPE ");
        os.print(this.getName());
        if (this._publicId != null) {
            os.print(" PUBLIC \"");
            os.print(this._publicId);
            os.print("\" \"");
            os.print(this._systemId);
            os.print("\"");
        } else if (this._systemId != null) {
            os.print(" SYSTEM \"");
            os.print(this._systemId);
            os.print("\"");
        }
        if (this._firstChild != null) {
            os.println(" [");
            QAbstractNode node = this._firstChild;
            while (node != null) {
                node.print(os);
                node = node._next;
            }
            os.print("]>");
        } else {
            os.print(">");
        }
    }
}

