/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.i18n;

import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;

public class UTF8Writer
extends EncodingWriter {
    private static final UTF8Writer _writer = new UTF8Writer();

    public String getJavaEncoding() {
        return "UTF8";
    }

    public EncodingWriter create(String javaEncoding) {
        return _writer;
    }

    public void write(OutputStreamWithBuffer os, char ch) throws IOException {
        if (ch < '\u0080') {
            os.write(ch);
        } else if (ch < '\u0800') {
            os.write(192 + (ch >> 6));
            os.write(128 + (ch & 0x3F));
        } else {
            os.write(224 + (ch >> 12));
            os.write(128 + (ch >> 6 & 0x3F));
            os.write(128 + (ch & 0x3F));
        }
    }

    public void write(OutputStreamWithBuffer os, char[] cbuf, int off, int len) throws IOException {
        byte[] buffer = os.getBuffer();
        int length = os.getBufferOffset();
        int capacity = buffer.length;
        for (int i = 0; i < len; ++i) {
            char ch;
            if (capacity <= length + 2) {
                buffer = os.nextBuffer(length);
                length = 0;
            }
            if ((ch = cbuf[off + i]) < '\u0080') {
                buffer[length++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                buffer[length++] = (byte)(192 + (ch >> 6));
                buffer[length++] = (byte)(128 + (ch & 0x3F));
                continue;
            }
            buffer[length++] = (byte)(224 + (ch >> 12));
            buffer[length++] = (byte)(128 + (ch >> 6 & 0x3F));
            buffer[length++] = (byte)(128 + (ch & 0x3F));
        }
        os.setBufferOffset(length);
    }
}

