/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.QDate;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class TimestampFilter
extends StreamImpl {
    private WriteStream _stream;
    private String _timestamp;
    private QDate _calendar = new QDate(true);
    private boolean _isLineBegin = true;

    public TimestampFilter() {
    }

    public TimestampFilter(WriteStream out, String timestamp) {
        this._stream = out;
        this._timestamp = timestamp;
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    public void setStream(WriteStream stream) {
        this._stream = stream;
    }

    public boolean canWrite() {
        return this._stream != null && this._stream.canWrite();
    }

    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        if (this._stream == null) {
            return;
        }
        if (this._timestamp == null) {
            this._stream.write(buffer, offset, length);
            return;
        }
        long now = CauchoSystem.isTesting() ? Alarm.getCurrentTime() : System.currentTimeMillis();
        for (int i = 0; i < length; ++i) {
            if (this._isLineBegin) {
                this._stream.print(QDate.formatLocal(now, this._timestamp));
                this._isLineBegin = false;
            }
            byte ch = buffer[offset + i];
            this._stream.write(ch);
            if (ch != 10 && (ch != 13 || i + 1 >= length || buffer[offset + i + 1] == 10)) continue;
            this._isLineBegin = true;
        }
    }

    public void flush() throws IOException {
        if (this._stream != null) {
            this._stream.flush();
        }
    }

    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
    }
}

