/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.TempCharBuffer;
import java.io.Reader;

public class TempCharReader
extends Reader {
    private TempCharBuffer _head;
    private char[] _buffer;
    private int _offset;
    private int _length;
    private boolean _isFree;

    public TempCharReader() {
    }

    public TempCharReader(TempCharBuffer head) {
        this.init(head);
    }

    public void setFree(boolean isFree) {
        this._isFree = isFree;
    }

    public void init(TempCharBuffer head) {
        this._head = head;
        if (head != null) {
            this._buffer = head.getBuffer();
            this._length = head.getLength();
        } else {
            this._length = 0;
        }
        this._offset = 0;
    }

    public int read() {
        if (this._length <= this._offset) {
            if (this._head == null) {
                return -1;
            }
            TempCharBuffer next = this._head.getNext();
            if (this._isFree) {
                TempCharBuffer.free(this._head);
            }
            this._head = next;
            if (this._head == null) {
                return -1;
            }
            this._buffer = this._head.getBuffer();
            this._length = this._head.getLength();
            this._offset = 0;
        }
        return this._buffer[this._offset++];
    }

    public int read(char[] buffer, int offset, int length) {
        int readLength = 0;
        while (length > 0) {
            int sublen;
            if (this._length <= this._offset) {
                if (this._head == null) {
                    return readLength == 0 ? -1 : readLength;
                }
                TempCharBuffer next = this._head.getNext();
                if (this._isFree) {
                    TempCharBuffer.free(this._head);
                }
                this._head = next;
                if (this._head == null) {
                    return readLength == 0 ? -1 : readLength;
                }
                this._buffer = this._head.getBuffer();
                this._length = this._head.getLength();
                this._offset = 0;
            }
            if (length < (sublen = this._length - this._offset)) {
                sublen = length;
            }
            System.arraycopy(this._buffer, this._offset, buffer, offset, sublen);
            this._offset += sublen;
            offset += sublen;
            length -= sublen;
            readLength += sublen;
        }
        return readLength;
    }

    public boolean isEmpty() {
        return this._head == null;
    }

    public void close() {
        if (this._isFree) {
            TempCharBuffer.freeAll(this._head);
        }
        this._head = null;
        this._buffer = null;
        this._offset = 0;
        this._length = 0;
    }
}

