/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.FreeList;

public class TempCharBuffer {
    private static FreeList<TempCharBuffer> _freeList = new FreeList(32);
    public static int SIZE = 8192;
    TempCharBuffer _next;
    final char[] _buf;
    private int _offset;
    int _length;
    int _bufferCount;

    public TempCharBuffer(int size) {
        this._buf = new char[size];
    }

    public static TempCharBuffer allocate() {
        TempCharBuffer next = _freeList.allocate();
        if (next == null) {
            return new TempCharBuffer(SIZE);
        }
        next._next = null;
        next._offset = 0;
        next._length = 0;
        next._bufferCount = 0;
        return next;
    }

    public void clear() {
        this._next = null;
        this._offset = 0;
        this._length = 0;
        this._bufferCount = 0;
    }

    public final char[] getBuffer() {
        return this._buf;
    }

    public final int getLength() {
        return this._length;
    }

    public final void setLength(int length) {
        this._length = length;
    }

    public final int getCapacity() {
        return this._buf.length;
    }

    public int getAvailable() {
        return this._buf.length - this._length;
    }

    public final TempCharBuffer getNext() {
        return this._next;
    }

    public final void setNext(TempCharBuffer next) {
        this._next = next;
    }

    public int write(char[] buf, int offset, int length) {
        char[] thisBuf = this._buf;
        int thisLength = this._length;
        if (thisBuf.length - thisLength < length) {
            length = thisBuf.length - thisLength;
        }
        System.arraycopy(buf, offset, thisBuf, thisLength, length);
        this._length = thisLength + length;
        return length;
    }

    public static void free(TempCharBuffer buf) {
        buf._next = null;
        if (buf._buf.length == SIZE) {
            _freeList.free(buf);
        }
    }

    public static void freeAll(TempCharBuffer buf) {
        while (buf != null) {
            TempCharBuffer next = buf._next;
            buf._next = null;
            if (buf._buf.length == SIZE) {
                _freeList.free(buf);
            }
            buf = next;
        }
    }
}

