/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.NullIterator;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.MailtoPath;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SmtpStream
extends MemoryStream {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/vfs/SmtpStream"));
    ArrayList<MailtoPath.Recipient> _to;
    ArrayList<MailtoPath.Recipient> _cc;
    ArrayList<MailtoPath.Recipient> _bcc;
    private String _from;
    private String _sender;
    private HashMap<String, Object> _attributes;
    boolean _isClosed;

    SmtpStream(ArrayList<MailtoPath.Recipient> to, HashMap<String, Object> attributes) throws IOException {
        if (to.size() <= 0) {
            throw new IOException("No recipients in mailto");
        }
        this._to = new ArrayList();
        for (int i = 0; i < to.size(); ++i) {
            this._to.add(to.get(i));
        }
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                try {
                    this.setAttribute(key, attributes.get(key));
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public Object getAttribute(String name) throws IOException {
        if (this._attributes != null) {
            return this._attributes.get(name.toLowerCase());
        }
        return null;
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this._attributes != null) {
            return this._attributes.keySet().iterator();
        }
        return NullIterator.create();
    }

    @Override
    public void setAttribute(String name, Object value) throws IOException {
        if ((name = name.toLowerCase()).equals("date") || name.equals("received") || name.equals("return-path") || name.equals("message-id")) {
            throw new IOException(new StringBuffer().append("cannot set property `").append(name).append("'").toString());
        }
        if (name.equals("to")) {
            this.addTo((String)value);
            return;
        }
        if (name.equals("cc")) {
            this.addCc((String)value);
            return;
        }
        if (name.equals("bcc")) {
            this.addBcc((String)value);
            return;
        }
        if (name.equals("from")) {
            this._from = (String)value;
            return;
        }
        if (name.equals("sender")) {
            this._sender = (String)value;
            return;
        }
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        this._attributes.put(name, value);
    }

    public void addTo(String to) throws IOException {
        StringCharCursor cursor = new StringCharCursor(to);
        ArrayList<MailtoPath.Recipient> list = MailtoPath.parseAddressList(cursor);
        for (int i = 0; i < list.size(); ++i) {
            this._to.add(list.get(i));
        }
    }

    public void addCc(String to) throws IOException {
        StringCharCursor cursor = new StringCharCursor(to);
        ArrayList<MailtoPath.Recipient> list = MailtoPath.parseAddressList(cursor);
        if (this._cc == null) {
            this._cc = list;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this._cc.add(list.get(i));
            }
        }
    }

    public void addBcc(String to) throws IOException {
        StringCharCursor cursor = new StringCharCursor(to);
        ArrayList<MailtoPath.Recipient> list = MailtoPath.parseAddressList(cursor);
        if (this._bcc == null) {
            this._bcc = list;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this._bcc.add(list.get(i));
            }
        }
    }

    public String getFrom() {
        if (this._from != null) {
            return this._from;
        }
        return Registry.getString("/caucho.com/smtp.vfs/sender", null);
    }

    public String getSender() {
        if (this._sender != null) {
            return this._sender;
        }
        return Registry.getString("/caucho.com/smtp.vfs/sender", null);
    }

    private int readResponse(InputStream is, CharBuffer msg) throws IOException {
        int value;
        do {
            msg.clear();
            value = 0;
            int ch = is.read();
            if (ch >= 48 && ch <= 57) {
                while (ch >= 48 && ch <= 57) {
                    msg.append((char)ch);
                    value = 10 * value + ch - 48;
                    ch = is.read();
                }
            }
            if (ch == 45) {
                value = 0;
            }
            while (ch != 13 && ch != 10) {
                msg.append((char)ch);
                ch = is.read();
            }
            if (ch != 13) continue;
            ch = is.read();
        } while (value == 0);
        if (log.isLoggable(Level.FINE)) {
            log.fine(msg.toString());
        }
        return value;
    }

    void sendRecipients(ReadStream is, WriteStream os, ArrayList<MailtoPath.Recipient> to, CharBuffer msg) throws IOException {
        if (to == null) {
            return;
        }
        for (int i = 0; i < to.size(); ++i) {
            MailtoPath.Recipient rcpt = to.get(i);
            os.print("RCPT TO: ");
            os.print(rcpt.user);
            if (rcpt.host != null) {
                os.print("@");
                os.print(rcpt.host);
            }
            os.print("\r\n");
            if (log.isLoggable(Level.FINE)) {
                log.fine(new StringBuffer().append("RCPT TO: ").append(rcpt.user).append("@").append(rcpt.host).toString());
            }
            if (this.readResponse(is, msg) / 100 == 2) continue;
            throw new IOException(new StringBuffer().append("Expected '221' from SMTP: ").append((Object)msg).toString());
        }
    }

    private void writeMessageBody(WriteStream os) throws IOException {
        ReadStream is = this.openRead();
        int ch = is.read();
        if (ch < 0) {
            os.print(".\r\n");
            return;
        }
        while (ch >= 0) {
            if (ch == 10) {
                ch = is.read();
                if (ch == 46) {
                    os.print("\r\n..");
                    ch = is.read();
                    continue;
                }
                if (ch <= 0) {
                    os.print("\r\n.\r\n");
                    return;
                }
                os.print("\r\n");
                continue;
            }
            os.write(ch);
            ch = is.read();
        }
        os.print("\r\n.\r\n");
    }

    private void writeMessage(WriteStream os) throws IOException {
        String from = this.getFrom();
        os.print("From: ");
        if (from != null) {
            os.print(from);
        } else {
            os.print(CauchoSystem.getUserName());
            os.print("@");
            os.print(CauchoSystem.getLocalHost());
        }
        os.print("\r\n");
        String date = QDate.formatLocal(Alarm.getCurrentTime(), "%a, %d %b %Y %H:%M:%S %z");
        os.print(new StringBuffer().append("Date: ").append(date).append("\r\n").toString());
        os.print("To: ");
        this.writeMessageRecipients(os, this._to);
        if (this._cc != null && this._cc.size() > 0) {
            os.print("Cc: ");
            this.writeMessageRecipients(os, this._cc);
        }
        Iterator<String> iter = this.getAttributeNames();
        while (iter != null && iter.hasNext()) {
            String key = iter.next();
            Object value = this.getAttribute(key);
            if (value == null) continue;
            os.print(key);
            os.print(": ");
            os.print(String.valueOf(value));
            os.print("\r\n");
        }
        String sender = this.getSender();
        if (this._from != sender && !this._from.equals(sender)) {
            os.print("Sender: ");
            if (sender != null) {
                os.print(sender);
            } else {
                os.print(CauchoSystem.getUserName());
                os.print("@");
                os.print(CauchoSystem.getLocalHost());
            }
            os.print("\r\n");
        }
        os.print("\r\n");
        this.writeMessageBody(os);
    }

    private void writeMessageRecipients(WriteStream os, ArrayList<MailtoPath.Recipient> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            MailtoPath.Recipient rcpt = list.get(i);
            if (i != 0) {
                os.print(", ");
            }
            os.print(rcpt.user);
            if (rcpt.host == null) continue;
            os.print("@");
            os.print(rcpt.host);
        }
        os.print("\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        String host = Registry.getString("/caucho.com/smtp.vfs/host", "localhost");
        int port = Registry.getInt("/caucho.com/smtp.vfs/port", 25);
        Socket sock = new Socket(host, port);
        CharBuffer msg = new CharBuffer();
        ReadStream is = null;
        WriteStream os = null;
        try {
            ReadWritePair s = VfsStream.openReadWrite(sock.getInputStream(), sock.getOutputStream());
            is = s.getReadStream();
            os = s.getWriteStream();
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException("Expected '220' from SMTP");
            }
            os.print("HELO ");
            os.print(CauchoSystem.getLocalHost());
            os.print("\r\n");
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException("Expected '220' from SMTP");
            }
            os.print("MAIL FROM: ");
            String sender = this.getSender();
            if (sender != null) {
                os.print(sender);
            } else {
                os.print(CauchoSystem.getUserName());
                os.print("@");
                os.print(CauchoSystem.getLocalHost());
            }
            os.print("\r\n");
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException(new StringBuffer().append("Expected '250' from SMTP: ").append((Object)msg).toString());
            }
            this.sendRecipients(is, os, this._to, msg);
            if (this._cc != null) {
                this.sendRecipients(is, os, this._cc, msg);
            }
            if (this._bcc != null) {
                this.sendRecipients(is, os, this._bcc, msg);
            }
            os.print("DATA\r\n");
            if (this.readResponse(is, msg) / 100 != 3) {
                throw new IOException(new StringBuffer().append("Expected '354' from SMTP: ").append((Object)msg).toString());
            }
            this.writeMessage(os);
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException(new StringBuffer().append("Expected '200' from SMTP: ").append((Object)msg).toString());
            }
            os.print("QUIT\r\n");
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException(new StringBuffer().append("Expected '250' from SMTP: ").append((Object)msg).toString());
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            finally {
                sock.close();
            }
            this.destroy();
        }
    }
}

