/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QServerSocketWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SSLFactory;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class JsseSSLFactory
implements SSLFactory {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/vfs/JsseSSLFactory"));
    private String _keyStoreFile;
    private String _alias;
    private String _password;
    private String _verifyClient;
    private String _keyStoreType = "jks";
    private String _keyManagerFactory = "SunX509";
    private String _sslContext = "TLS";
    private KeyStore _keyStore;

    public void setKeyStoreFile(String keyStoreFile) {
        this._keyStoreFile = keyStoreFile;
    }

    public String getKeyStoreFile() {
        return this._keyStoreFile;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setVerifyClient(String verifyClient) {
        this._verifyClient = verifyClient;
    }

    public String getVerifyClient() {
        return this._verifyClient;
    }

    public void setKeyManagerFactory(String keyManagerFactory) {
        this._keyManagerFactory = keyManagerFactory;
    }

    public void setSSLContext(String sslContext) {
        this._sslContext = sslContext;
    }

    public void setKeyStoreType(String keyStore) {
        this._keyStoreType = keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ConfigException, IOException, GeneralSecurityException {
        if (this._keyStoreFile == null) {
            throw new ConfigException(L.l("`key-store-file' is required for JSSE."));
        }
        if (this._password == null) {
            throw new ConfigException(L.l("`password' is required for JSSE."));
        }
        this._keyStore = KeyStore.getInstance(this._keyStoreType);
        ReadStream is = Vfs.openRead(this._keyStoreFile);
        try {
            this._keyStore.load(is, this._password.toCharArray());
        }
        finally {
            ((InputStream)is).close();
        }
        if (this._alias != null) {
            Key key = this._keyStore.getKey(this._alias, this._password.toCharArray());
            if (key == null) {
                throw new ConfigException(L.l("JSSE alias '{0}' does not have a corresponding key.", this._alias));
            }
            Certificate[] certChain = this._keyStore.getCertificateChain(this._alias);
            if (certChain == null) {
                throw new ConfigException(L.l("JSSE alias '{0}' does not have a corresponding certificate chain.", this._alias));
            }
            this._keyStore = KeyStore.getInstance(this._keyStoreType);
            this._keyStore.load(null, this._password.toCharArray());
            this._keyStore.setKeyEntry(this._alias, key, this._password.toCharArray(), certChain);
        }
    }

    public QServerSocket create(InetAddress host, int port) throws IOException, GeneralSecurityException {
        if (this._keyStore == null) {
            throw new IOException(L.l("key store is missing"));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this._keyManagerFactory);
        kmf.init(this._keyStore, this._password.toCharArray());
        SSLContext sslContext = SSLContext.getInstance(this._sslContext);
        sslContext.init(kmf.getKeyManagers(), null, null);
        SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
        int listen = 100;
        ServerSocket serverSocket = host == null ? factory.createServerSocket(port, listen) : factory.createServerSocket(port, listen, host);
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket;
        if ("required".equals(this._verifyClient)) {
            sslServerSocket.setNeedClientAuth(true);
        }
        return new QServerSocketWrapper(serverSocket);
    }
}

