/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.make.CachedDependency;
import com.caucho.make.PersistentDependency;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.LruCache;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Jar
implements CacheListener {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/vfs/Jar"));
    private static LruCache<Path, Jar> _jarCache;
    private static EnvironmentLocal<Integer> _jarSize;
    private Path _backing;
    private JarDepend _depend;
    private long _lastModified;
    private long _length;
    private long _lastTime;
    private SoftReference<JarFile> _jarFileRef;
    private long _jarLastModified;
    private SoftReference<JarFile> _closeJarFileRef;

    private Jar(Path backing) {
        this._backing = backing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Jar create(Path backing) {
        if (_jarCache == null) {
            int size = 256;
            Integer iSize = _jarSize.get();
            if (iSize != null) {
                size = iSize;
            }
            _jarCache = new LruCache(size);
        }
        LruCache<Path, Jar> lruCache = _jarCache;
        synchronized (lruCache) {
            Jar jar = _jarCache.get(backing);
            if (jar == null) {
                jar = new Jar(backing);
                _jarCache.put(backing, jar);
            }
            return jar;
        }
    }

    public static PersistentDependency createDepend(Path backing) {
        Jar jar = Jar.create(backing);
        return jar.getDepend();
    }

    public static PersistentDependency createDepend(Path backing, String digest) {
        Jar jar = Jar.create(backing);
        return new JarDigestDepend(jar.getJarDepend(), digest);
    }

    Path getBacking() {
        return this._backing;
    }

    public PersistentDependency getDepend() {
        return this.getJarDepend();
    }

    private JarDepend getJarDepend() {
        if (this._depend == null || this._depend.isModified()) {
            this._depend = new JarDepend(new Depend(this.getBacking()));
        }
        return this._depend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        Manifest manifest;
        Jar jar = this;
        synchronized (jar) {
            JarFile jarFile = this.getJarFile();
            manifest = jarFile == null ? null : jarFile.getManifest();
        }
        this.closeJarFile();
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean exists(String path) {
        boolean exists;
        Jar jar = this;
        synchronized (jar) {
            exists = this.getSafeJarEntry(path) != null;
        }
        this.closeJarFile();
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(String path) {
        boolean isDirectory;
        Jar jar = this;
        synchronized (jar) {
            ZipEntry entry;
            if (!path.endsWith("/")) {
                path = path + '/';
            }
            isDirectory = (entry = this.getSafeJarEntry(path)) == null && (path.equals("/") || path.equals("")) ? true : entry != null && entry.isDirectory();
        }
        this.closeJarFile();
        return isDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFile(String path) {
        boolean isFile;
        Jar jar = this;
        synchronized (jar) {
            ZipEntry entry = this.getSafeJarEntry(path);
            isFile = entry != null && !entry.isDirectory();
        }
        this.closeJarFile();
        return isFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(String path) {
        long lastModified;
        Jar jar = this;
        synchronized (jar) {
            ZipEntry entry = this.getSafeJarEntry(path);
            lastModified = entry == null ? 0L : this._lastModified;
        }
        this.closeJarFile();
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength(Path path) {
        long length;
        Jar jar = this;
        synchronized (jar) {
            ZipEntry entry = this.getSafeJarEntry(path.getPath());
            length = entry == null ? -1L : entry.getSize();
        }
        this.closeJarFile();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(String path) {
        boolean canRead;
        Jar jar = this;
        synchronized (jar) {
            canRead = this._backing.canRead() && this.isFile(path);
        }
        this.closeJarFile();
        return canRead;
    }

    public boolean canWrite(String path) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list(String pathName) throws IOException {
        if (pathName.length() > 0 && !pathName.endsWith("/")) {
            pathName = pathName + "/";
        }
        if (pathName.startsWith("/")) {
            pathName = pathName.substring(1);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] result = null;
        Jar jar = this;
        synchronized (jar) {
            JarFile jarFile = this.getJarFile();
            if (jarFile != null) {
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(pathName) || name.equals(pathName)) continue;
                    String subName = name.substring(pathName.length());
                    int p = subName.indexOf(47);
                    if (p < 0) {
                        list.add(subName);
                        continue;
                    }
                    if (p != subName.length() - 1) continue;
                    list.add(subName.substring(0, p));
                }
                result = list.toArray(new String[list.size()]);
            }
        }
        this.closeJarFile();
        if (result != null) {
            return result;
        }
        ReadStream backingIs = this._backing.openRead();
        ZipInputStream is = new ZipInputStream(backingIs);
        try {
            ZipEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.startsWith(pathName) || name.equals(pathName)) continue;
                String subName = name.substring(pathName.length());
                int p = subName.indexOf(47);
                if (p < 0) {
                    list.add(subName);
                    continue;
                }
                if (p != subName.length() - 1) continue;
                list.add(subName.substring(0, p));
            }
        }
        finally {
            is.close();
            backingIs.close();
        }
        return list.toArray(new String[list.size()]);
    }

    public StreamImpl openReadImpl(Path path) throws IOException {
        String pathName = path.getPath();
        if (pathName.length() > 0 && pathName.charAt(0) == '/') {
            pathName = pathName.substring(1);
        }
        ZipFile zipFile = new ZipFile(this._backing.getNativePath());
        InputStream is = null;
        try {
            ZipEntry entry = zipFile.getEntry(pathName);
            if (entry != null) {
                is = zipFile.getInputStream(entry);
                ZipStreamImpl zipStreamImpl = new ZipStreamImpl(zipFile, is, null, path);
                return zipStreamImpl;
            }
            throw new FileNotFoundException(path.toString());
        }
        finally {
            if (is == null) {
                zipFile.close();
            }
        }
    }

    public String toString() {
        return this._backing.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJarCache() {
        LruCache<Path, Jar> jarCache = _jarCache;
        if (jarCache == null) {
            return;
        }
        ArrayList<Jar> jars = new ArrayList<Jar>();
        LruCache<Path, Jar> lruCache = jarCache;
        synchronized (lruCache) {
            Iterator<Jar> iter = jarCache.values();
            while (iter.hasNext()) {
                jars.add(iter.next());
            }
        }
        for (int i = 0; i < jars.size(); ++i) {
            Jar jar = (Jar)jars.get(i);
            if (jar == null) continue;
            jar.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        JarFile jarFile = null;
        Jar jar = this;
        synchronized (jar) {
            SoftReference<JarFile> jarFileRef = this._jarFileRef;
            this._jarFileRef = null;
            if (jarFileRef != null) {
                jarFile = jarFileRef.get();
            }
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ZipEntry getSafeJarEntry(String path) {
        try {
            return this.getJarEntry(path);
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    private ZipEntry getJarEntry(String path) throws IOException {
        JarFile jarFile;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((jarFile = this.getJarFile()) != null) {
            return jarFile.getEntry(path);
        }
        return null;
    }

    private JarFile getJarFile() throws IOException {
        SoftReference<JarFile> jarFileRef;
        JarFile jarFile = null;
        if (this.getLastModifiedImpl() == this._jarLastModified && (jarFileRef = this._jarFileRef) != null && (jarFile = jarFileRef.get()) != null) {
            return jarFile;
        }
        SoftReference<JarFile> oldJarRef = this._jarFileRef;
        this._jarFileRef = null;
        ZipFile oldFile = null;
        if (oldJarRef != null) {
            if (this._closeJarFileRef == null) {
                this._closeJarFileRef = oldJarRef;
            } else {
                oldFile = oldJarRef.get();
            }
        }
        if (oldFile != null) {
            try {
                oldFile.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this._backing.getScheme().equals("file") && this._backing.canRead()) {
            jarFile = new JarFile(this._backing.getNativePath());
            this._jarFileRef = new SoftReference<JarFile>(jarFile);
            this._jarLastModified = this.getLastModifiedImpl();
        }
        return jarFile;
    }

    private long getLastModifiedImpl() {
        long now = Alarm.getCurrentTime();
        if (now == this._lastTime) {
            return this._lastModified;
        }
        long oldLastModified = this._lastModified;
        long oldLength = this._length;
        this._lastModified = this._backing.getLastModified();
        this._length = this._backing.getLength();
        this._lastTime = now;
        if (this._lastModified != oldLastModified || this._length != oldLength) {
            SoftReference<JarFile> oldFileRef = this._jarFileRef;
            this._jarFileRef = null;
            this._jarLastModified = 0L;
            JarFile oldCloseFile = null;
            if (this._closeJarFileRef != null) {
                oldCloseFile = this._closeJarFileRef.get();
            }
            this._closeJarFileRef = oldFileRef;
            if (oldCloseFile != null) {
                try {
                    oldCloseFile.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return this._lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeJarFile() {
        JarFile jarFile = null;
        Jar jar = this;
        synchronized (jar) {
            if (this._closeJarFileRef != null) {
                jarFile = this._closeJarFileRef.get();
            }
            this._closeJarFileRef = null;
        }
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent() {
        JarFile jarFile = null;
        Jar jar = this;
        synchronized (jar) {
            if (this._jarFileRef != null) {
                jarFile = this._jarFileRef.get();
            }
            this._jarFileRef = null;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.closeJarFile();
    }

    static {
        _jarSize = new EnvironmentLocal("caucho.vfs.jar-size");
    }

    static class JarDigestDepend
    implements PersistentDependency {
        private JarDepend _jarDepend;
        private Depend _depend;
        private boolean _isDigestModified;

        JarDigestDepend(JarDepend jarDepend, String digest) {
            this._jarDepend = jarDepend;
            this._depend = jarDepend.getDepend();
            this._isDigestModified = !this._depend.getDigest().equals(digest);
        }

        public boolean isModified() {
            return this._isDigestModified || this._jarDepend.isModified();
        }

        public String getJavaCreateString() {
            String sourcePath = this._depend.getPath().getPath();
            String digest = this._depend.getDigest();
            return "new com.caucho.vfs.Jar.createDepend(com.caucho.vfs.Vfs.lookup(\"" + sourcePath + "\"), " + "\"" + digest + "\")";
        }
    }

    static class JarDepend
    extends CachedDependency
    implements PersistentDependency {
        private Depend _depend;
        private boolean _isDigestModified;

        JarDepend(Depend depend) {
            this._depend = depend;
        }

        JarDepend(Depend depend, String digest) {
            this._depend = depend;
            this._isDigestModified = !this._depend.getDigest().equals(digest);
        }

        Depend getDepend() {
            return this._depend;
        }

        public boolean isModifiedImpl() {
            return this._isDigestModified || this._depend.isModified();
        }

        public String getJavaCreateString() {
            String sourcePath = this._depend.getPath().getPath();
            String digest = this._depend.getDigest();
            return "new com.caucho.vfs.Jar.createDepend(com.caucho.vfs.Vfs.lookup(\"" + sourcePath + "\"), " + "\"" + digest + "\")";
        }

        public String toString() {
            return "Jar$JarDepend[" + this._depend.getPath() + "]";
        }
    }

    static class ZipStreamImpl
    extends StreamImpl {
        private ZipFile _zipFile;
        private InputStream _zis;
        private InputStream _is;

        ZipStreamImpl(ZipFile file, InputStream zis, InputStream is, Path path) {
            this._zipFile = file;
            this._zis = zis;
            this._is = is;
            this.setPath(path);
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() throws IOException {
            if (this._zis == null) {
                return -1;
            }
            return this._zis.available();
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int readLen = this._zis.read(buf, off, len);
            return readLen;
        }

        public void close() throws IOException {
            ZipFile zipFile = this._zipFile;
            this._zipFile = null;
            InputStream zis = this._zis;
            this._zis = null;
            InputStream is = this._is;
            this._is = null;
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (is != null) {
                is.close();
            }
        }

        protected void finalize() throws IOException {
            this.close();
        }
    }
}

