/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class GzipStream
extends OutputStream {
    private static Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/vfs/GzipStream"));
    private final Deflater _deflater = new Deflater(-1, true);
    private final CRC32 _crc = new CRC32();
    private final byte[] _buffer = new byte[1024];
    private final byte[] _byteBuffer = new byte[1];
    private OutputStream _os;
    private boolean _enable;
    private boolean _isFirst;

    public GzipStream() {
    }

    public GzipStream(OutputStream os) throws IOException {
        this.init(os);
    }

    public void init(OutputStream os) {
        this._os = os;
        this._enable = true;
        this._deflater.reset();
        this._crc.reset();
        this._isFirst = true;
    }

    public void setEnable(boolean enable) {
        this._enable = enable;
    }

    public boolean canWrite() {
        return this._os != null;
    }

    public void write(int v) throws IOException {
        this._byteBuffer[0] = (byte)v;
        this.write(this._byteBuffer, 0, 1);
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        OutputStream os = this._os;
        if (os == null) {
            return;
        }
        if (!this._enable) {
            os.write(buf, offset, length);
        } else {
            int sublen;
            if (this._isFirst) {
                this._isFirst = false;
                GzipStream.writeHeader(os);
            }
            this._deflater.setInput(buf, offset, length);
            this._crc.update(buf, offset, length);
            while ((sublen = this._deflater.deflate(this._buffer, 0, this._buffer.length)) > 0) {
                os.write(this._buffer, 0, sublen);
            }
        }
    }

    public void closeWrite() throws IOException {
        int sublen;
        OutputStream os = this._os;
        if (os == null || !this._enable) {
            return;
        }
        if (this._isFirst) {
            GzipStream.writeHeader(os);
        }
        this._deflater.finish();
        while ((sublen = this._deflater.deflate(this._buffer, 0, this._buffer.length)) > 0) {
            os.write(this._buffer, 0, sublen);
        }
        this.writeFooter(os);
    }

    private static void writeHeader(OutputStream os) throws IOException {
        os.write(31);
        os.write(139);
        os.write(8);
        os.write(0);
        os.write(0);
        os.write(0);
        os.write(0);
        os.write(0);
        os.write(0);
        os.write(0);
    }

    private void writeFooter(OutputStream os) throws IOException {
        GzipStream.writeInt(os, (int)this._crc.getValue());
        GzipStream.writeInt(os, this._deflater.getTotalIn());
    }

    private static void writeInt(OutputStream os, int i) throws IOException {
        os.write(i & 0xFF);
        os.write(i >> 8 & 0xFF);
        os.write(i >> 16 & 0xFF);
        os.write(i >> 24 & 0xFF);
    }

    private static void writeShort(OutputStream os, int i) throws IOException {
        os.write(i & 0xFF);
        os.write(i >> 8 & 0xFF);
    }

    public void flush() throws IOException {
        this._os.flush();
    }

    public void close() throws IOException {
        this.closeWrite();
        OutputStream os = this._os;
        this._os = null;
        if (os != null) {
            os.close();
        }
    }
}

