/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.FileReadStream;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Jar;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.VfsStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePath
extends FilesystemPath {
    private static byte[] NEWLINE = CauchoSystem.getNewlineString().getBytes();
    private File _file;

    protected FilePath(FilesystemPath root, String userPath, String path) {
        super(root, userPath, path);
        this._separatorChar = CauchoSystem.getFileSeparatorChar();
    }

    FilePath(String path) {
        this(Vfs.PWD != null ? Vfs.PWD._root : null, path, FilePath.normalizePath("/", FilePath.initialPath(path), 0, CauchoSystem.getFileSeparatorChar()));
        if (this._root == null) {
            this._root._root = this._root = new FilePath(null, "/", "/");
        }
        this._separatorChar = this._root._separatorChar;
    }

    protected static String initialPath(String path) {
        if (path == null) {
            return FilePath.getPwd();
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return path;
        }
        String dir = FilePath.getPwd();
        if (dir.length() > 0 && dir.charAt(dir.length() - 1) == '/') {
            return new StringBuffer().append(dir).append(path).toString();
        }
        return new StringBuffer().append(dir).append("/").append(path).toString();
    }

    private static String getPwd() {
        String path = CauchoSystem.getUserDir();
        path = path.replace(CauchoSystem.getFileSeparatorChar(), '/');
        if (CauchoSystem.isWindows()) {
            path = FilePath.convertFromWindowsPath(path);
        }
        return path;
    }

    private static String convertFromWindowsPath(String path) {
        char ch;
        int colon = path.indexOf(58);
        int length = path.length();
        if (colon == 1 && (ch = path.charAt(0)) != '/' && ch != '\\') {
            return new StringBuffer().append("/").append(path.charAt(0)).append(":/").append(path.substring(2)).toString();
        }
        if (!(length <= 1 || (ch = path.charAt(0)) != '/' && ch != '\\' || (ch = path.charAt(1)) != '/' && ch != '\\')) {
            if (colon < 0) {
                return new StringBuffer().append("/:").append(path).toString();
            }
            for (int i = colon - 2; i > 1; --i) {
                ch = path.charAt(i);
                if (ch == '/' || ch == '\\') continue;
                return new StringBuffer().append("/:").append(path).toString();
            }
            ch = path.charAt(colon - 1);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                return path.substring(colon - 2);
            }
            return new StringBuffer().append("/:").append(path).toString();
        }
        return path;
    }

    @Override
    protected Path schemeWalk(String userPath, Map<String, Object> attributes, String filePath, int offset) {
        if (!CauchoSystem.isWindows()) {
            return super.schemeWalk(userPath, attributes, filePath, offset);
        }
        if (filePath.length() < offset + 2) {
            return super.schemeWalk(userPath, attributes, filePath, offset);
        }
        char ch1 = filePath.charAt(offset + 1);
        char ch2 = filePath.charAt(offset);
        if (!(ch2 != '/' && ch2 != this._separatorChar || ch1 != '/' && ch1 != this._separatorChar)) {
            return super.schemeWalk(userPath, attributes, FilePath.convertFromWindowsPath(filePath.substring(offset)), 0);
        }
        return super.schemeWalk(userPath, attributes, filePath, offset);
    }

    @Override
    protected Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        return new FilePath(this._root, userPath, path);
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public String getNativePath() {
        char ch;
        if (this._separatorChar == '/' && !CauchoSystem.isWindows()) {
            return this.getFullPath();
        }
        String path = this.getFullPath();
        int length = path.length();
        CharBuffer cb = CharBuffer.allocate();
        int offset = 0;
        if (CauchoSystem.isWindows()) {
            if (length >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':' && ((ch = path.charAt(1)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                offset = 1;
            } else if (length >= 3 && path.charAt(0) == '/' && path.charAt(1) == ':' && path.charAt(2) == '/') {
                cb.append('\\');
                cb.append('\\');
                offset = 3;
            }
        }
        while (offset < length) {
            ch = path.charAt(offset);
            if (ch == '/') {
                cb.append(this._separatorChar);
            } else {
                cb.append(ch);
            }
            ++offset;
        }
        return cb.close();
    }

    @Override
    public boolean exists() {
        if (this._separatorChar == '\\' && this.isAux()) {
            return false;
        }
        return this.getFile().exists();
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public boolean isFile() {
        if (this._separatorChar == '\\' && this.isAux()) {
            return false;
        }
        return this.getFile().isFile();
    }

    @Override
    public long getLength() {
        return this.getFile().length();
    }

    @Override
    public long getLastModified() {
        return this.getFile().lastModified();
    }

    @Override
    public void setLastModified(long time) {
        this.getFile().setLastModified(time);
    }

    @Override
    public boolean canRead() {
        File file = this.getFile();
        if (this._separatorChar == '\\' && this.isAux()) {
            return false;
        }
        return file.canRead();
    }

    @Override
    public boolean canWrite() {
        File file = this.getFile();
        if (this._separatorChar == '\\' && this.isAux()) {
            return false;
        }
        return file.canWrite();
    }

    @Override
    public String[] list() throws IOException {
        String[] list = this.getFile().list();
        if (list != null) {
            return list;
        }
        return new String[0];
    }

    @Override
    public boolean mkdir() throws IOException {
        boolean value = this.getFile().mkdir();
        if (!value && !this.getFile().isDirectory()) {
            throw new IOException("cannot create directory");
        }
        return value;
    }

    @Override
    public boolean mkdirs() throws IOException {
        boolean value = this.getFile().mkdirs();
        if (!value && !this.getFile().isDirectory()) {
            throw new IOException(new StringBuffer().append("Cannot create directory: ").append(this.getFile()).toString());
        }
        return value;
    }

    @Override
    public boolean remove() {
        if (this.getFile().delete()) {
            return true;
        }
        if (this.getPath().endsWith(".jar")) {
            Jar.create(this).clearCache();
            return this.getFile().delete();
        }
        return false;
    }

    @Override
    public boolean renameTo(Path path) {
        if (!(path instanceof FilePath)) {
            return false;
        }
        FilePath file = (FilePath)path;
        return this.getFile().renameTo(file.getFile());
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        if (this._separatorChar == '\\' && this.isAux()) {
            throw new FileNotFoundException(this._file.toString());
        }
        return new FileReadStream(new FileInputStream(this.getFile()), this);
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        VfsStream os = new VfsStream(null, new FileOutputStream(this.getFile()), this);
        os.setNewline(NEWLINE);
        return os;
    }

    @Override
    public StreamImpl openAppendImpl() throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getFile().toString(), true);
        }
        catch (IOException e) {
            fos = new FileOutputStream(this.getFile().toString());
        }
        VfsStream os = new VfsStream(null, fos);
        os.setNewline(NEWLINE);
        return os;
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        VfsStream os = new VfsStream(new FileInputStream(this.getFile()), new FileOutputStream(this.getFile()), this);
        os.setNewline(NEWLINE);
        return os;
    }

    @Override
    public int hashCode() {
        return this.getFile().hashCode();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof FilePath)) {
            return false;
        }
        FilePath file = (FilePath)b;
        return this.getFullPath().equals(file.getFullPath());
    }

    public File getFile() {
        if (this._file != null) {
            return this._file;
        }
        this._file = CauchoSystem.isTesting() ? new File(this.getFullPath()) : new File(this.getNativePath());
        return this._file;
    }

    protected boolean isAux() {
        File file = this.getFile();
        String path = this.getFullPath().toLowerCase();
        int len = path.length();
        int p = path.indexOf("/aux");
        if (p >= 0 && (p + 4 >= len || path.charAt(p + 4) == '.')) {
            return true;
        }
        p = path.indexOf("/con");
        if (p >= 0 && (p + 4 >= len || path.charAt(p + 4) == '.')) {
            return true;
        }
        p = path.indexOf("/nul");
        return p >= 0 && (p + 4 >= len || path.charAt(p + 4) == '.');
    }
}

