/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public abstract class AbstractPrintWriter
extends PrintWriter {
    private static final char[] _trueChars = "true".toCharArray();
    private static final char[] _falseChars = "false".toCharArray();
    private static final char[] _nullChars = "null".toCharArray();
    private static final Writer _dummyWriter = new StringWriter();
    private final char[] _tempCharBuffer = new char[64];

    public abstract void write(char[] var1, int var2, int var3);

    public abstract void write(int var1);

    public abstract void write(String var1, int var2, int var3);

    protected AbstractPrintWriter() {
        super(_dummyWriter);
    }

    public final void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    public final void write(String s) {
        this.write(s, 0, s.length());
    }

    public void newLine() {
        this.write(10);
    }

    public final void print(boolean b) {
        this.write(b ? _trueChars : _falseChars);
    }

    public void print(char ch) {
        this.write(ch);
    }

    public void print(int i) {
        if (i == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (i < 0) {
            this.write(45);
            i = -i;
        } else if (i < 9) {
            this.write(48 + i);
            return;
        }
        int length = 0;
        int exp = 10;
        if (i >= 1000000000) {
            length = 9;
        } else {
            while (i >= exp) {
                exp = 10 * exp;
                ++length;
            }
        }
        int j = 31;
        while (i > 0) {
            this._tempCharBuffer[--j] = (char)(i % 10 + 48);
            i /= 10;
        }
        this.write(this._tempCharBuffer, j, 31 - j);
    }

    public void print(long v) {
        if (v == Long.MIN_VALUE) {
            this.print("-9223372036854775808");
            return;
        }
        if (v < 0L) {
            this.write(45);
            v = -v;
        } else if (v == 0L) {
            this.write(48);
            return;
        }
        int j = 31;
        while (v > 0L) {
            this._tempCharBuffer[--j] = (char)(v % 10L + 48L);
            v /= 10L;
        }
        this.write(this._tempCharBuffer, j, 31 - j);
    }

    public final void print(float f) {
        this.write(String.valueOf(f));
    }

    public final void print(double d) {
        this.write(String.valueOf(d));
    }

    public final void print(char[] s) {
        this.write(s, 0, s.length);
    }

    public final void print(String s) {
        if (s == null) {
            this.write(_nullChars, 0, _nullChars.length);
        } else {
            this.write(s, 0, s.length());
        }
    }

    public final void print(Object v) {
        if (v == null) {
            this.write(_nullChars, 0, _nullChars.length);
        } else {
            String s = v.toString();
            this.write(s, 0, s.length());
        }
    }

    public void println() {
        this.write(10);
    }

    public final void println(boolean v) {
        this.print(v);
        this.println();
    }

    public final void println(char v) {
        this.print(v);
        this.println();
    }

    public final void println(int v) {
        this.print(v);
        this.println();
    }

    public final void println(long v) {
        this.print(v);
        this.println();
    }

    public final void println(float v) {
        String s = String.valueOf(v);
        this.write(s, 0, s.length());
        this.println();
    }

    public final void println(double v) {
        String s = String.valueOf(v);
        this.write(s, 0, s.length());
        this.println();
    }

    public final void println(char[] s) {
        this.write(s, 0, s.length);
        this.println();
    }

    public final void println(String s) {
        if (s == null) {
            this.write(_nullChars, 0, _nullChars.length);
        } else {
            this.write(s, 0, s.length());
        }
        this.println();
    }

    public final void println(Object v) {
        if (v == null) {
            this.write(_nullChars, 0, _nullChars.length);
        } else {
            String s = v.toString();
            this.write(s, 0, s.length());
        }
        this.println();
    }
}

