/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakLruCache<K, V> {
    private CacheItem[] _entries;
    private int _capacity;
    private int _size;
    private int _mask;
    private CacheItem<K, V> _head;
    private CacheItem<K, V> _tail;
    private static Integer NULL = new Integer(0);

    public WeakLruCache(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this._entries = new CacheItem[capacity];
        this._mask = capacity - 1;
        this._capacity = initialCapacity;
    }

    public int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        ArrayList<CacheListener> listeners = null;
        WeakLruCache weakLruCache = this;
        synchronized (weakLruCache) {
            for (int i2 = 0; i2 < this._entries.length; ++i2) {
                Object value;
                CacheItem item = this._entries[i2];
                if (item != null && (value = item.getValue()) instanceof CacheListener) {
                    if (listeners == null) {
                        listeners = new ArrayList<CacheListener>();
                    }
                    listeners.add((CacheListener)value);
                }
                this._entries[i2] = null;
            }
            this._size = 0;
            this._head = null;
            this._tail = null;
        }
        int n = i = listeners == null ? -1 : listeners.size() - 1;
        while (i >= 0) {
            CacheListener listener = (CacheListener)listeners.get(i);
            listener.removeEvent();
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = okey.hashCode() & this._mask;
        WeakLruCache weakLruCache = this;
        synchronized (weakLruCache) {
            for (int count = this._size + 1; count > 0; --count) {
                CacheItem item = this._entries[hash];
                if (item == null) {
                    return null;
                }
                if (item._key == key || item._key.equals(key)) {
                    this.updateLru(item);
                    return item.getValue();
                }
                hash = hash + 1 & this._mask;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        while (this._capacity <= this._size) {
            this.remove(this._tail._key);
        }
        V oldValue = null;
        int hash = key.hashCode() & this._mask;
        WeakLruCache weakLruCache = this;
        synchronized (weakLruCache) {
            for (int count = this._size + 1; count > 0; --count) {
                CacheItem<K, V> item = this._entries[hash];
                if (item == null) {
                    this._entries[hash] = item = new CacheItem<K, V>(key, value);
                    ++this._size;
                    item._next = this._head;
                    if (this._head != null) {
                        this._head._prev = item;
                    } else {
                        this._tail = item;
                    }
                    this._head = item;
                    return null;
                }
                if (item._key == okey || item._key.equals(okey)) {
                    this.updateLru(item);
                    oldValue = item.getValue();
                    item.setValue(value);
                    break;
                }
                hash = hash + 1 & this._mask;
            }
        }
        if (oldValue instanceof CacheListener && oldValue != value) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    private void updateLru(CacheItem<K, V> item) {
        CacheItem prev = item._prev;
        CacheItem next = item._next;
        if (prev != null) {
            prev._next = next;
            item._prev = null;
            item._next = this._head;
            this._head._prev = item;
            this._head = item;
            if (next != null) {
                next._prev = prev;
            } else {
                this._tail = prev;
            }
        }
    }

    public boolean removeTail() {
        CacheItem<K, V> last = this._tail;
        if (last == null) {
            return false;
        }
        this.remove(last._key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        int count;
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = key.hashCode() & this._mask;
        V value = null;
        WeakLruCache weakLruCache = this;
        synchronized (weakLruCache) {
            for (count = this._size + 1; count > 0; --count) {
                CacheItem item = this._entries[hash];
                if (item == null) {
                    return null;
                }
                if (item._key == okey || item._key.equals(okey)) {
                    int nextHash;
                    CacheItem nextItem;
                    this._entries[hash] = null;
                    --this._size;
                    CacheItem prev = item._prev;
                    CacheItem next = item._next;
                    if (prev != null) {
                        prev._next = next;
                    } else {
                        this._head = next;
                    }
                    if (next != null) {
                        next._prev = prev;
                    } else {
                        this._tail = prev;
                    }
                    for (int i = 1; i <= count && (nextItem = this._entries[nextHash = hash + i & this._mask]) != null; ++i) {
                        this._entries[nextHash] = null;
                        this.refillEntry(nextItem);
                    }
                    value = item.getValue();
                    break;
                }
                hash = hash + 1 & this._mask;
            }
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        if (value instanceof CacheListener) {
            ((CacheListener)value).removeEvent();
        }
        return value;
    }

    private void refillEntry(CacheItem<K, V> item) {
        int baseHash = item._key.hashCode();
        for (int count = 0; count < this._size + 1; ++count) {
            int hash = baseHash + count & this._mask;
            if (this._entries[hash] != null) continue;
            this._entries[hash] = item;
            return;
        }
    }

    public Iterator<K> keys() {
        KeyIterator iter = new KeyIterator();
        iter.init(this);
        return iter;
    }

    public Iterator<K> keys(Iterator<K> oldIter) {
        KeyIterator iter = (KeyIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public Iterator<V> values() {
        ValueIterator iter = new ValueIterator();
        iter.init(this);
        return iter;
    }

    public Iterator<V> values(Iterator<V> oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<K, V>
    implements Iterator<V> {
        CacheItem<K, V> _item;

        ValueIterator() {
        }

        void init(WeakLruCache<K, V> cache) {
            this._item = ((WeakLruCache)cache)._head;
        }

        @Override
        public boolean hasNext() {
            return this._item != null;
        }

        @Override
        public V next() {
            V value = this._item.getValue();
            this._item = this._item._next;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyIterator<K, V>
    implements Iterator<K> {
        CacheItem<K, V> _item;

        KeyIterator() {
        }

        void init(WeakLruCache<K, V> cache) {
            this._item = ((WeakLruCache)cache)._head;
        }

        @Override
        public boolean hasNext() {
            return this._item != null;
        }

        @Override
        public K next() {
            Object key = this._item._key;
            this._item = this._item._next;
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheItem<K, V> {
        CacheItem<K, V> _prev;
        CacheItem<K, V> _next;
        K _key;
        private WeakReference<V> _value;
        int _index;

        CacheItem(K key, V value) {
            this._key = key;
            this._value = value == null ? null : new WeakReference<V>(value);
        }

        public final V getValue() {
            WeakReference<V> ref = this._value;
            if (ref == null) {
                return null;
            }
            return (V)ref.get();
        }

        public final void setValue(V value) {
            this._value = value == null ? null : new WeakReference<V>(value);
        }
    }
}

