/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.util.Alarm;
import com.caucho.util.ChangeListener;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.util.QDate;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlParser;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierFilter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Registry {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/util/Registry"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/util/Registry"));
    private static Registry _defaultRegistry;
    private static int _changeCount;
    private static ArrayList<ChangeListener> _listeners;
    private RegistryNode _top;
    private ArrayList<Depend> _dependList = new ArrayList();
    private long _lastModifiedCheck;
    private boolean _isModified;

    public RegistryNode createNode(String name, String value) {
        return new RegistryNode(this, name, value, null, 0);
    }

    public boolean isModified() {
        long now = Alarm.getCurrentTime();
        if (this._isModified) {
            return true;
        }
        if (now < this._lastModifiedCheck + 1000L) {
            return false;
        }
        this._lastModifiedCheck = now;
        for (int i = this._dependList.size() - 1; i >= 0; --i) {
            Dependency depend = this._dependList.get(i);
            if (!depend.isModified()) continue;
            this._isModified = true;
            return true;
        }
        return false;
    }

    public ArrayList<Depend> getDependList() {
        return this._dependList;
    }

    public RegistryNode getTop() {
        return this._top;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry parse(Path path) throws IOException, SAXException {
        ReadStream is = null;
        try {
            is = path.openRead();
            Registry registry = Registry.parse(is);
            return registry;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry parse(InputStream is) throws IOException, SAXException {
        ReadStream rs = Vfs.openRead(is);
        try {
            Registry registry = Registry.parse(rs);
            return registry;
        }
        finally {
            rs.close();
        }
    }

    public static Registry parse(ReadStream is) throws IOException, SAXException {
        RegistryNode top;
        Registry root = new Registry();
        root._top = top = new RegistryNode(root, null, null, null, 0);
        Registry.parse(is, top);
        return root;
    }

    static RegistryNode parse(ReadStream is, RegistryNode top) throws IOException, SAXException {
        Xml parser = new Xml();
        parser.setResinInclude(true);
        Path path = is.getPath();
        if (path != null) {
            top.getRoot()._dependList.add(new Depend(path));
        }
        SaxHandler handler = new SaxHandler(path, top);
        parser.setContentHandler(handler);
        parser.parse(is);
        return top;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry parse(Path path, Schema schema) throws IOException, SAXException {
        ReadStream is = null;
        try {
            is = path.openRead();
            Registry registry = Registry.parse(is, schema);
            return registry;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry parse(InputStream is, Schema schema) throws IOException, SAXException {
        ReadStream rs = Vfs.openRead(is);
        try {
            Registry registry = Registry.parse(rs, schema);
            return registry;
        }
        finally {
            rs.close();
        }
    }

    public static Registry parse(ReadStream is, Schema schema) throws IOException, SAXException {
        RegistryNode top;
        Registry root = new Registry();
        root._top = top = new RegistryNode(root, null, null, null, 0);
        Registry.parse(is, top, schema);
        return root;
    }

    static RegistryNode parse(ReadStream is, RegistryNode top, Schema schema) throws IOException, SAXException {
        try {
            Xml xmlParser = new Xml();
            xmlParser.setResinInclude(true);
            Path path = is.getPath();
            if (path != null) {
                xmlParser.setSearchPath(path.getParent());
                top.getRoot()._dependList.add(new Depend(path));
            }
            Xml parser = xmlParser;
            SaxHandler handler = new SaxHandler(path, top);
            if (schema != null) {
                Verifier verifier = schema.newVerifier();
                VerifierFilter filter = verifier.getVerifierFilter();
                filter.setParent((XMLReader)parser);
                parser = filter;
            }
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            InputSource source = new InputSource(is);
            source.setSystemId(is.getUserPath());
            parser.parse(source);
            return top;
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            SAXException e1 = new SAXException(e);
            e1.initCause(e);
            throw e1;
        }
    }

    public static synchronized Registry setDefault(Registry registry) {
        return Registry.setRegistry(registry);
    }

    public static synchronized Registry setRegistry(Registry registry) {
        Registry old = _defaultRegistry;
        _defaultRegistry = registry;
        if (old != null) {
            old._isModified = true;
        }
        if (registry != null) {
            registry._isModified = false;
        }
        Registry.handleChange();
        return old;
    }

    public static synchronized Registry getRegistry() {
        return _defaultRegistry;
    }

    public static RegistryNode lookup(String path) {
        Registry registry = Registry.getRegistry();
        if (registry == null) {
            return null;
        }
        RegistryNode node = registry._top;
        return node == null ? null : node.lookup(path);
    }

    public static boolean getBoolean(String path, boolean deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getBoolean();
    }

    public static int getInt(String path, int deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getInt();
    }

    public static double getDouble(String path, double deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getDouble();
    }

    public static String getString(String path, String deflt) {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getString();
    }

    public static String getPath(String path, String deflt) {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getPath();
    }

    public static QDate getDate(String path, QDate deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getDate();
    }

    public static long getPeriod(String path, long deflt) throws RegistryException {
        RegistryNode node = Registry.lookup(path);
        return node == null ? deflt : node.getPeriod();
    }

    public static synchronized void addListener(ChangeListener listener) {
        if (_listeners == null) {
            _listeners = new ArrayList();
        }
        _listeners.add(listener);
    }

    public static int getChangeCount() {
        return _changeCount;
    }

    public static synchronized void removeListener(ChangeListener listener) {
        if (_listeners != null) {
            _listeners.remove(listener);
        }
    }

    static void handleChange() {
        ++_changeCount;
        if (_listeners == null) {
            return;
        }
        for (int i = 0; i < _listeners.size(); ++i) {
            ChangeListener listener = _listeners.get(i);
            listener.handleChange(null);
        }
    }

    static class SAXCompileException
    extends SAXException
    implements LineCompileException {
        public SAXCompileException(String msg) {
            super(msg);
        }
    }

    static class SaxHandler
    extends DefaultHandler {
        Path _path;
        private Locator _locator;
        ArrayList _elements = new ArrayList();
        RegistryNode _node;
        private boolean _hasText;
        private boolean _hasTag;
        private boolean _preserveSpace;

        SaxHandler(Path path, RegistryNode top) {
            this._path = path;
            this._node = top;
        }

        Registry getRoot() {
            return this._node.getRoot();
        }

        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (this._hasText) {
                throw this.error(L.l("Element <{0}> is forbidden because parent tag <{1}> already contains text.  Tags must either contain other tags or text, not both.", (Object)qName, this._node.getName()));
            }
            if (qName.equals("resin:include")) {
                this.doInclude(attrs);
                return;
            }
            String name = localName;
            RegistryNode child = this._locator instanceof XmlParser ? this._node.add(name, null, ((XmlParser)((Object)this._locator)).getFilename(), this._locator.getLineNumber()) : this._node.add(name, null, this._locator.getSystemId(), this._locator.getLineNumber());
            this._node = child;
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                String key = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (key.equals("id")) {
                    child._id = value;
                    child._value = value;
                    continue;
                }
                if (key.equals("xml:space")) {
                    if (!value.equals("preserve")) continue;
                    this._preserveSpace = true;
                    continue;
                }
                if (key.equals("xmlns") || key.startsWith("xmlns:")) continue;
                child.add(key, value, this._locator.getSystemId(), this._locator.getLineNumber());
            }
            this._hasText = false;
            this._hasTag = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doInclude(Attributes args) throws SAXException {
            try {
                String href = args.getValue("href");
                if (href == null) {
                    throw new SAXException("resin:include expects `href' attribute");
                }
                Path subpath = this._path.getParent().lookup(href);
                if (!subpath.canRead()) {
                    throw new SAXException(L.l("can't find `{0}' in resin:include", subpath));
                }
                ReadStream is = null;
                try {
                    is = subpath.openRead();
                    Registry.parse(is, this._node);
                    RegistryNode child = this._node.getFirstChild();
                    if (child != null) {
                        this._node = child;
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new SAXException(e.toString());
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this._node != null) {
                this._node = this._node._parent;
            }
            this._hasText = false;
            this._preserveSpace = false;
            this._hasTag = true;
        }

        private boolean isWhitespace(char ch) {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public void characters(char[] chars, int offset, int length) throws SAXException {
            char ch = ' ';
            if (!this._preserveSpace) {
                while (length > 0 && ((ch = chars[offset]) == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) {
                    ++offset;
                    --length;
                }
                ch = ' ';
                while (length > 0 && ((ch = chars[offset + length - 1]) == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) {
                    --length;
                }
            } else if (length > 0) {
                ch = chars[offset];
            }
            if (length <= 0) {
                return;
            }
            if (this._hasTag) {
                throw this.error(L.l("Text `{0}' is forbidden because parent tag <{1}> already contains a tag.  Tags must either contain other tags or text, not both.", (Object)new String(chars, offset, length), this._node.getName()));
            }
            if (this._node._id != null) {
                throw this.error("can't use both id=value and text at `" + ch + "'");
            }
            this._node._value = this._node._value == null ? new String(chars, offset, length) : this._node._value + new String(chars, offset, length);
            if (!this._preserveSpace) {
                this._node._value = this._node._value.trim();
            }
            this._hasText = true;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            log.log(Level.FINER, e.toString(), e);
            throw this.error(e.getMessage());
        }

        public void error(SAXParseException e) throws SAXException {
            log.log(Level.FINER, e.toString(), e);
            throw this.error(e.getMessage());
        }

        public void warning(SAXParseException e) throws SAXException {
            log.log(Level.WARNING, e.toString(), e);
        }

        SAXException error(String text) {
            return new SAXCompileException(this._locator.getSystemId() + ":" + this._locator.getLineNumber() + ": " + text);
        }

        public SAXException createError(Exception e) {
            if (e instanceof SAXException) {
                return (SAXException)e;
            }
            return new SAXException(e);
        }
    }
}

