/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Random;

public class RandomUtil {
    private static long _seed = System.currentTimeMillis();
    private static Random _random;
    private static boolean _isTest;

    public static synchronized long getRandomLong() {
        if (_random == null) {
            _random = new Random(_seed);
        }
        return _random.nextLong();
    }

    public static synchronized int nextInt(int n) {
        if (_random == null) {
            _random = new Random(_seed);
        }
        return _random.nextInt(n);
    }

    public static void addRandom(String random) {
        if (random == null) {
            return;
        }
        for (int i = 0; i < random.length(); ++i) {
            RandomUtil.addRandom(random.charAt(i));
        }
    }

    public static void addRandom(long random) {
        _seed += random;
        _seed = _seed * 25214903917L + 11L + (_seed >>> 32) * 137L;
        if (!_isTest) {
            _random = null;
        }
    }

    public static void setTestSeed(long seed) {
        _seed = seed;
        _isTest = true;
        _random = new Random(seed);
    }
}

