/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatCache<K, V> {
    private Object[] _keys;
    private V[] _values;
    private int _capacity = 32;
    private int _mask;
    private static Object NULL = new Object();

    public FlatCache(int initialCapacity) {
        while (this._capacity < 2 * initialCapacity) {
            this._capacity *= 2;
        }
        this._keys = new Object[this._capacity];
        this._values = new Object[this._capacity];
        this._mask = this._capacity - 1;
    }

    public synchronized void clear() {
        for (int i = 0; i < this._capacity; ++i) {
            if (this._values[i] instanceof CacheListener) {
                ((CacheListener)this._values[i]).removeEvent();
            }
            this._keys[i] = null;
            this._values[i] = null;
        }
    }

    public Object get(K key) {
        int hash;
        Object testKey;
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        if ((testKey = this._keys[hash = okey.hashCode() & this._mask]) != null && testKey.equals(okey) && testKey == this._keys[hash]) {
            return this._values[hash];
        }
        return null;
    }

    public synchronized V put(K key, V value) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = okey.hashCode() & this._mask;
        V old = this._values[hash];
        this._keys[hash] = null;
        this._values[hash] = value;
        this._keys[hash] = okey;
        if (old instanceof CacheListener) {
            ((CacheListener)old).removeEvent();
        }
        return old;
    }

    public V remove(K key) {
        return this.put(key, null);
    }
}

