/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;

public class Base64 {
    static int[] decode;

    public static void encode(CharBuffer cb, long data) {
        cb.append(Base64.encode(data >> 60));
        cb.append(Base64.encode(data >> 54));
        cb.append(Base64.encode(data >> 48));
        cb.append(Base64.encode(data >> 42));
        cb.append(Base64.encode(data >> 36));
        cb.append(Base64.encode(data >> 30));
        cb.append(Base64.encode(data >> 24));
        cb.append(Base64.encode(data >> 18));
        cb.append(Base64.encode(data >> 12));
        cb.append(Base64.encode(data >> 6));
        cb.append(Base64.encode(data));
    }

    public static void encode24(CharBuffer cb, int data) {
        cb.append(Base64.encode(data >> 18));
        cb.append(Base64.encode(data >> 12));
        cb.append(Base64.encode(data >> 6));
        cb.append(Base64.encode(data));
    }

    public static void encode(CharBuffer cb, byte[] buffer, int offset, int length) {
        int data;
        while (length >= 3) {
            data = (buffer[offset] & 0xFF) << 16;
            data += (buffer[offset + 1] & 0xFF) << 8;
            cb.append(Base64.encode((data += buffer[offset + 2] & 0xFF) >> 18));
            cb.append(Base64.encode(data >> 12));
            cb.append(Base64.encode(data >> 6));
            cb.append(Base64.encode(data));
            offset += 3;
            length -= 3;
        }
        if (length == 2) {
            int b1 = buffer[offset] & 0xFF;
            int b2 = buffer[offset + 1] & 0xFF;
            int data2 = (b1 << 16) + (b2 << 8);
            cb.append(Base64.encode(data2 >> 18));
            cb.append(Base64.encode(data2 >> 12));
            cb.append(Base64.encode(data2 >> 6));
            cb.append('=');
        } else if (length == 1) {
            data = (buffer[offset] & 0xFF) << 16;
            cb.append(Base64.encode(data >> 18));
            cb.append(Base64.encode(data >> 12));
            cb.append('=');
            cb.append('=');
        }
    }

    public static void oldEncode(CharBuffer cb, byte[] buffer, int offset, int length) {
        int data;
        while (length >= 3) {
            data = (buffer[offset] & 0xFF) << 16;
            data += (buffer[offset + 1] & 0xFF) << 8;
            cb.append(Base64.encode((data += buffer[offset + 2] & 0xFF) >> 18));
            cb.append(Base64.encode(data >> 12));
            cb.append(Base64.encode(data >> 6));
            cb.append(Base64.encode(data));
            offset += 3;
            length -= 3;
        }
        if (length == 2) {
            int b1 = buffer[offset] & 0xFF;
            int b2 = buffer[offset + 1] & 0xFF;
            int data2 = (b1 << 8) + b2;
            cb.append(Base64.encode(data2 >> 12));
            cb.append(Base64.encode(data2 >> 6));
            cb.append(Base64.encode(data2));
            cb.append('=');
        } else if (length == 1) {
            data = buffer[offset] & 0xFF;
            cb.append(Base64.encode(data >> 6));
            cb.append(Base64.encode(data));
            cb.append('=');
            cb.append('=');
        }
    }

    public static char encode(long d) {
        if ((d &= 0x3FL) < 26L) {
            return (char)(d + 65L);
        }
        if (d < 52L) {
            return (char)(d + 97L - 26L);
        }
        if (d < 62L) {
            return (char)(d + 48L - 52L);
        }
        if (d == 62L) {
            return '+';
        }
        return '/';
    }

    public static int decode(int d) {
        return decode[d];
    }

    public static String encode(String value) {
        long chunk;
        CharBuffer cb = new CharBuffer();
        int i = 0;
        i = 0;
        while (i + 2 < value.length()) {
            chunk = value.charAt(i);
            chunk = (chunk << 8) + (long)value.charAt(i + 1);
            chunk = (chunk << 8) + (long)value.charAt(i + 2);
            cb.append(Base64.encode(chunk >> 18));
            cb.append(Base64.encode(chunk >> 12));
            cb.append(Base64.encode(chunk >> 6));
            cb.append(Base64.encode(chunk));
            i += 3;
        }
        if (i + 1 < value.length()) {
            chunk = value.charAt(i);
            chunk = (chunk << 8) + (long)value.charAt(i + 1);
            cb.append(Base64.encode((chunk <<= 8) >> 18));
            cb.append(Base64.encode(chunk >> 12));
            cb.append(Base64.encode(chunk >> 6));
            cb.append('=');
        } else if (i < value.length()) {
            chunk = value.charAt(i);
            cb.append(Base64.encode((chunk <<= 16) >> 18));
            cb.append(Base64.encode(chunk >> 12));
            cb.append('=');
            cb.append('=');
        }
        return cb.toString();
    }

    public static String decode(String value) {
        CharBuffer cb = new CharBuffer();
        int length = value.length();
        int i = 0;
        while (i + 3 < length) {
            int ch0 = value.charAt(i + 0) & 0xFF;
            if (ch0 == 32 || ch0 == 10 || ch0 == 13) {
                i -= 3;
            } else {
                int ch1 = value.charAt(i + 1) & 0xFF;
                int ch2 = value.charAt(i + 2) & 0xFF;
                int ch3 = value.charAt(i + 3) & 0xFF;
                int chunk = (decode[ch0] << 18) + (decode[ch1] << 12) + (decode[ch2] << 6) + decode[ch3];
                cb.append((char)(chunk >> 16 & 0xFF));
                if (ch2 != 61) {
                    cb.append((char)(chunk >> 8 & 0xFF));
                }
                if (ch3 != 61) {
                    cb.append((char)(chunk & 0xFF));
                }
            }
            i += 4;
        }
        return cb.toString();
    }

    static {
        int i;
        decode = new int[256];
        for (i = 65; i <= 90; ++i) {
            Base64.decode[i] = i - 65;
        }
        for (i = 97; i <= 122; ++i) {
            Base64.decode[i] = i - 97 + 26;
        }
        for (i = 48; i <= 57; ++i) {
            Base64.decode[i] = i - 48 + 52;
        }
        Base64.decode[43] = 62;
        Base64.decode[47] = 63;
    }
}

