/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.log.Log;
import com.caucho.util.AlarmListener;
import com.caucho.util.ThreadPool;
import com.caucho.util.ThreadTask;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Alarm
implements ThreadTask {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/util/Alarm"));
    private static final Integer timeLock = new Integer(0);
    private static volatile long _currentTime = System.currentTimeMillis();
    private static int _concurrentAlarmThrottle = 5;
    private static Object _queueLock = new Object();
    private static AlarmThread _alarmThread;
    private static Alarm[] _heap;
    private static int _heapTop;
    private static volatile int _runningAlarmCount;
    private static long _testTime;
    private static int _testCount;
    private long _wakeTime;
    private AlarmListener _listener;
    private ClassLoader _contextLoader;
    private String _name;
    private int _heapIndex = 0;
    private volatile boolean _isRunning;

    protected Alarm() {
        this._name = "alarm";
    }

    public Alarm(AlarmListener listener) {
        this("alarm", listener);
    }

    public Alarm(String name, AlarmListener listener) {
        this(name, listener, Thread.currentThread().getContextClassLoader());
    }

    public Alarm(String name, AlarmListener listener, ClassLoader loader) {
        this._name = name;
        this.setListener(listener);
        this.setContextLoader(loader);
    }

    public Alarm(String name, AlarmListener listener, long delta) {
        this(listener);
        this._name = name;
        this.queue(delta);
    }

    public Alarm(AlarmListener listener, long delta) {
        this(listener);
        this.queue(delta);
    }

    public String getName() {
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public static long getCurrentTime() {
        return _currentTime;
    }

    public static long getExactTime() {
        if (_testTime > 0L) {
            return _testTime;
        }
        return System.currentTimeMillis();
    }

    public static boolean isTest() {
        return _testTime > 0L;
    }

    public long getWakeTime() {
        return this._wakeTime;
    }

    public AlarmListener getListener() {
        return this._listener;
    }

    public void setListener(AlarmListener listener) {
        this._listener = listener;
    }

    public void setContextLoader(ClassLoader loader) {
        this._contextLoader = loader;
    }

    public ClassLoader getContextLoader() {
        return this._contextLoader;
    }

    public boolean isQueued() {
        return this._heapIndex != 0;
    }

    boolean isRunning() {
        return this._isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(long delta) {
        Object object = _queueLock;
        synchronized (object) {
            long wakeTime;
            if (this._heapIndex > 0) {
                Alarm.dequeueImpl(this);
            }
            this._wakeTime = wakeTime = delta + Alarm.getCurrentTime();
            Alarm.insertImpl(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue() {
        Object object = _queueLock;
        synchronized (object) {
            if (this._heapIndex > 0) {
                Alarm.dequeueImpl(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.handleAlarm();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            Object object = _queueLock;
            synchronized (object) {
                this._isRunning = false;
                --_runningAlarmCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAlarm() {
        AlarmListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.getContextLoader();
        if (loader != null) {
            thread.setContextClassLoader(loader);
        } else {
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        try {
            listener.handleAlarm(this);
        }
        finally {
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
    }

    public void close() {
        this.dequeue();
        this._listener = null;
        this._contextLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Alarm extractAlarm() {
        long now = Alarm.getCurrentTime();
        Object object = _queueLock;
        synchronized (object) {
            Alarm[] heap = _heap;
            Alarm alarm = heap[1];
            if (alarm == null) {
                return null;
            }
            if (now < alarm._wakeTime) {
                return null;
            }
            Alarm.dequeueImpl(alarm);
            return alarm;
        }
    }

    private static void insertImpl(Alarm item) {
        if (item._heapIndex != 0) {
            throw new IllegalStateException();
        }
        if (_heap.length <= _heapTop + 2) {
            Alarm[] newHeap = new Alarm[2 * _heap.length];
            System.arraycopy(_heap, 0, newHeap, 0, _heap.length);
            _heap = newHeap;
        }
        Alarm[] heap = _heap;
        int i = ++_heapTop;
        long wakeTime = item._wakeTime;
        while (i > 1) {
            int parent = i >> 1;
            Alarm alarm = heap[parent];
            if (wakeTime >= alarm._wakeTime) break;
            heap[i] = alarm;
            alarm._heapIndex = i;
            i = parent;
        }
        heap[i] = item;
        item._heapIndex = i;
        if (_heapTop < i) {
            throw new IllegalStateException();
        }
    }

    private static void dequeueImpl(Alarm item) {
        int i = item._heapIndex;
        if (i < 1) {
            return;
        }
        if (_heapTop < i) {
            throw new IllegalStateException("bad heap: " + _heapTop + " index:" + i);
        }
        Alarm[] heap = _heap;
        if (_heapTop < 1) {
            throw new IllegalStateException();
        }
        int size = _heapTop--;
        heap[i] = heap[size];
        heap[i]._heapIndex = i;
        heap[size] = null;
        item._heapIndex = 0;
        if (size == i) {
            return;
        }
        if (item._wakeTime < heap[i]._wakeTime) {
            while (i < size) {
                int right;
                item = heap[i];
                int minIndex = i;
                long minWakeTime = item._wakeTime;
                int left = i << 1;
                if (left < size && heap[left]._wakeTime < minWakeTime) {
                    minIndex = left;
                    minWakeTime = heap[left]._wakeTime;
                }
                if ((right = left + 1) < size && heap[right]._wakeTime < minWakeTime) {
                    minIndex = right;
                }
                if (i == minIndex) {
                    return;
                }
                heap[i] = heap[minIndex];
                heap[i]._heapIndex = i;
                heap[minIndex] = item;
                item._heapIndex = minIndex;
                i = minIndex;
            }
        } else {
            item = heap[i];
            long wakeTime = item._wakeTime;
            while (i > 1) {
                int parent = i >> 1;
                Alarm alarm = heap[parent];
                if (wakeTime >= alarm._wakeTime) break;
                heap[i] = alarm;
                alarm._heapIndex = i;
                i = parent;
            }
            heap[i] = item;
            item._heapIndex = i;
        }
    }

    static void testClear() {
        while (_heapTop > 0) {
            Alarm alarm = _heap[_heapTop];
            alarm._heapIndex = 0;
            Alarm._heap[Alarm._heapTop] = null;
            --_heapTop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTestTime(long time) {
        _testTime = time;
        if (_testTime > 0L) {
            if (time < _currentTime) {
                Alarm.testClear();
            }
            _currentTime = time;
        } else {
            _currentTime = System.currentTimeMillis();
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            Alarm alarm;
            while ((alarm = Alarm.extractAlarm()) != null) {
                alarm.run();
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        try {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String toString() {
        return "Alarm[" + this._name + "]";
    }

    static {
        _heap = new Alarm[256];
        _currentTime = System.currentTimeMillis();
        _alarmThread = new AlarmThread();
        _alarmThread.start();
    }

    private static class CoordinatorTask
    implements ThreadTask {
        private boolean _isRunning;

        private CoordinatorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule() {
            boolean isRunning;
            CoordinatorTask coordinatorTask = this;
            synchronized (coordinatorTask) {
                isRunning = this._isRunning;
                this._isRunning = true;
            }
            if (!isRunning) {
                ThreadPool.schedulePriority(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Alarm alarm;
                Thread thread = Thread.currentThread();
                while ((alarm = Alarm.extractAlarm()) != null) {
                    if (_concurrentAlarmThrottle < _runningAlarmCount) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ThreadPool.startPriority(alarm);
                }
            }
            finally {
                this._isRunning = false;
            }
        }
    }

    static class AlarmThread
    extends Thread {
        private CoordinatorTask _coordinator = new CoordinatorTask();

        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (_testTime > 0L) {
                            _currentTime = _testTime;
                        } else {
                            _currentTime = System.currentTimeMillis();
                        }
                        this._coordinator.schedule();
                        Thread.sleep(500L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }

        AlarmThread() {
            super("resin-alarm");
            this.setDaemon(true);
        }
    }
}

