/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.log.Log;
import com.caucho.transaction.TransactionRuntimeException;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class TransactionContainer {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/transaction/TransactionContainer"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/transaction/TransactionContainer"));
    private static TransactionContainer _container;
    private UserTransaction _userTM;
    private TransactionManager _tm;

    public static TransactionContainer getTransactionContainer() {
        if (_container == null) {
            _container = new TransactionContainer();
            try {
                InitialContext ic = new InitialContext();
                UserTransaction userTM = (UserTransaction)ic.lookup("java:comp/UserTransaction");
                _container.setUserTransaction(userTM);
                TransactionManager tm = (TransactionManager)ic.lookup("java:comp/TransactionManager");
                _container.setTransactionManager(tm);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return _container;
    }

    public void setUserTransaction(UserTransaction userTM) {
        this._userTM = userTM;
    }

    public void setTransactionManager(TransactionManager tm) {
        this._tm = tm;
    }

    public Transaction beginRequired() {
        try {
            Transaction currentTrans = this._tm.getTransaction();
            if (currentTrans != null) {
                return currentTrans;
            }
            this._userTM.begin();
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public Transaction beginRequiresNew() {
        try {
            Transaction oldTrans = this._tm.getTransaction();
            if (oldTrans != null) {
                oldTrans = this._tm.suspend();
            }
            this._userTM.begin();
            return oldTrans;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public void beginMandatory() {
        try {
            Transaction oldTrans = this._tm.getTransaction();
            if (oldTrans == null) {
                throw new TransactionRuntimeException(L.l("'Mandatory' transaction boundary requires a transaction."));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public void beginNever() {
        try {
            Transaction oldTrans = this._tm.getTransaction();
            if (oldTrans != null) {
                throw new TransactionRuntimeException(L.l("'Never' transaction boundary must not have a transaction."));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public Transaction beginSuspend() {
        try {
            Transaction oldTrans = this._tm.getTransaction();
            if (oldTrans != null) {
                oldTrans = this._tm.suspend();
            }
            return oldTrans;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public void setRollbackOnly(Throwable e) {
    }

    public void commit(Transaction oldTransaction) {
        try {
            Transaction currentTrans = this._tm.getTransaction();
            if (currentTrans == null) {
            } else if (currentTrans.getStatus() != 1) {
                this._userTM.commit();
            } else {
                this._userTM.rollback();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
        finally {
            if (oldTransaction != null) {
                try {
                    this._tm.resume(oldTransaction);
                }
                catch (Exception e) {
                    throw new TransactionRuntimeException(e);
                }
            }
        }
    }

    public void rollback(Transaction oldTransaction) {
        try {
            Transaction currentTrans = this._tm.getTransaction();
            if (currentTrans != null) {
                this._userTM.rollback();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
        finally {
            if (oldTransaction != null) {
                try {
                    this._tm.resume(oldTransaction);
                }
                catch (Exception e) {
                    throw new TransactionRuntimeException(e);
                }
            }
        }
    }
}

