/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Logger;

public class SpyStatement
implements Statement {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyStatement"));
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyConnection"));
    protected String _id;
    protected Connection _conn;
    protected Statement _stmt;

    SpyStatement(String id, Connection conn, Statement stmt) {
        this._id = id;
        this._conn = conn;
        this._stmt = stmt;
    }

    public Statement getStatement() {
        return this._stmt;
    }

    public void addBatch(String sql) throws SQLException {
        try {
            log.info(this._id + ":addBatch(" + sql + ")");
            this._stmt.addBatch(sql);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-addBatch(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void cancel() throws SQLException {
        try {
            log.info(this._id + ":cancel()");
            this._stmt.cancel();
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-cancel(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            log.info(this._id + ":clearBatch()");
            this._stmt.clearBatch();
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-clearBatch(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            log.info(this._id + ":clearWarnings()");
            this._stmt.clearWarnings();
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-clearWarnings(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void close() throws SQLException {
        try {
            log.info(this._id + ":close()");
            this._stmt.close();
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-close(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            log.info(this._id + ":executeQuery(" + sql + ")");
            ResultSet rs = this._stmt.executeQuery(sql);
            return rs;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-executeQuery(" + sql + ") -> " + e);
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            int count = this._stmt.executeUpdate(sql);
            log.info(this._id + ":executeUpdate(" + sql + ") -> " + count);
            return count;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-executeUpdate(" + sql + ") -> " + e);
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            boolean hasResult = this._stmt.execute(sql);
            log.info(this._id + ":execute(" + sql + ") -> " + hasResult);
            return hasResult;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-execute(" + sql + ") -> " + e);
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            int[] result = this._stmt.executeBatch();
            log.info(this._id + ":executeBatch()");
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-executeBatch(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            ResultSet result = this._stmt.getResultSet();
            log.info(this._id + ":getResultSet() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getResultSet(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            int updateCount = this._stmt.getUpdateCount();
            log.info(this._id + ":getUpdateCount() -> " + updateCount);
            return updateCount;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getUpdateCount(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public Connection getConnection() throws SQLException {
        int updateCount = this._stmt.getUpdateCount();
        log.info(this._id + ":getConnection()");
        return this._conn;
    }

    public int getFetchDirection() throws SQLException {
        try {
            int result = this._stmt.getFetchDirection();
            log.info(this._id + ":getFetchDirection() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getFetchDirection(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            int result = this._stmt.getFetchSize();
            log.info(this._id + ":getFetchSize() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getFetchSize(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            int result = this._stmt.getMaxFieldSize();
            log.info(this._id + ":getMaxFieldSize() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getMaxFieldSize(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            int result = this._stmt.getMaxRows();
            log.info(this._id + ":getMaxRows() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getMaxRows(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        try {
            log.info(this._id + ":setMaxRows(" + max + ")");
            this._stmt.setMaxRows(max);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setMaxRows(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            boolean result = this._stmt.getMoreResults();
            log.info(this._id + ":getMoreResults() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getMoreResults(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            int result = this._stmt.getQueryTimeout();
            log.info(this._id + ":getQueryTimeout() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getQueryTimeout(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            int result = this._stmt.getResultSetConcurrency();
            log.info(this._id + ":getResultSetConcurrency() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getResultSetConcurrency(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            int result = this._stmt.getResultSetType();
            log.info(this._id + ":getResultSetType() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getResultSetType(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            SQLWarning result = this._stmt.getWarnings();
            log.info(this._id + ":getWarnings() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getWarnings(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setCursorName(String name) throws SQLException {
        try {
            log.info(this._id + ":setCursorName(" + name + ")");
            this._stmt.setCursorName(name);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setCursorName(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            log.info(this._id + ":setEscapeProcessing(" + enable + ")");
            this._stmt.setEscapeProcessing(enable);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setEscapeProcessing(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            log.info(this._id + ":setFetchDirection(" + direction + ")");
            this._stmt.setFetchDirection(direction);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setFetchDirection(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            log.info(this._id + ":setFetchSize(" + rows + ")");
            this._stmt.setFetchSize(rows);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setFetchSize(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            log.info(this._id + ":setMaxFieldSize(" + max + ")");
            this._stmt.setMaxFieldSize(max);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setMaxFieldSize(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            log.info(this._id + ":setQueryTimeout(" + seconds + ")");
            this._stmt.setQueryTimeout(seconds);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setQueryTimeout(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean getMoreResults(int count) throws SQLException {
        return this._stmt.getMoreResults(count);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this._stmt.getGeneratedKeys();
    }

    public int executeUpdate(String query, int resultType) throws SQLException {
        return this._stmt.executeUpdate(query, resultType);
    }

    public int executeUpdate(String query, int[] columns) throws SQLException {
        return this._stmt.executeUpdate(query, columns);
    }

    public int executeUpdate(String query, String[] columns) throws SQLException {
        return this._stmt.executeUpdate(query, columns);
    }

    public boolean execute(String query, int resultType) throws SQLException {
        return this._stmt.execute(query, resultType);
    }

    public boolean execute(String query, int[] columns) throws SQLException {
        return this._stmt.execute(query, columns);
    }

    public boolean execute(String query, String[] columns) throws SQLException {
        return this._stmt.execute(query, columns);
    }

    public int getResultSetHoldability() throws SQLException {
        return this._stmt.getResultSetHoldability();
    }
}

