/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.spy.SpyStatement;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Logger;

public class SpyPreparedStatement
extends SpyStatement
implements PreparedStatement {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyPreparedStatement"));
    protected static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyPreparedStatement"));
    private String _sql;
    protected PreparedStatement _pstmt;

    SpyPreparedStatement(String id, Connection conn, PreparedStatement stmt, String sql) {
        super(id, conn, stmt);
        this._pstmt = stmt;
        this._sql = sql;
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            log.info(this._id + ":executeQuery(" + this._sql + ")");
            ResultSet rs = this._pstmt.executeQuery();
            return rs;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-executeQuery(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            int result = this._pstmt.executeUpdate();
            log.info(this._id + ":executeUpdate(" + this._sql + ") -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-executeUpdate(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean execute() throws SQLException {
        try {
            boolean result = this._pstmt.execute();
            log.info(this._id + ":execute(" + this._sql + ") -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-execute(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void addBatch() throws SQLException {
        try {
            this._pstmt.addBatch();
            log.info(this._id + ":addBatch()");
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-addBatch(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            log.info(this._id + ":clearParameters()");
            this._pstmt.clearParameters();
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-clearParameters(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            ResultSetMetaData result = this._pstmt.getMetaData();
            log.info(this._id + ":getMetaData() -> " + result);
            return result;
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-getMetaData(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            log.info(this._id + ":setNull(" + parameterIndex + ",type=" + sqlType + ")");
            this._pstmt.setNull(parameterIndex, sqlType);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setNull(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            log.info(this._id + ":setNull(" + parameterIndex + ",type=" + sqlType + ",typeName=" + typeName + ")");
            this._pstmt.setNull(parameterIndex, sqlType, typeName);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setNull(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBoolean(int index, boolean value) throws SQLException {
        try {
            log.info(this._id + ":setBoolean(" + index + "," + value + ")");
            this._pstmt.setBoolean(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setBoolean(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setByte(int index, byte value) throws SQLException {
        try {
            log.info(this._id + ":setByte(" + index + "," + value + ")");
            this._pstmt.setByte(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setByte(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setShort(int index, short value) throws SQLException {
        try {
            log.info(this._id + ":setShort(" + index + "," + value + ")");
            this._pstmt.setShort(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setShort(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setInt(int index, int value) throws SQLException {
        try {
            log.info(this._id + ":setInt(" + index + "," + value + ")");
            this._pstmt.setInt(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setInt(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setLong(int index, long value) throws SQLException {
        try {
            log.info(this._id + ":setLong(" + index + "," + value + ")");
            this._pstmt.setLong(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setLong(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setFloat(int index, float value) throws SQLException {
        try {
            log.info(this._id + ":setFloat(" + index + "," + value + ")");
            this._pstmt.setFloat(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setFloat(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDouble(int index, double value) throws SQLException {
        try {
            log.info(this._id + ":setDouble(" + index + "," + value + ")");
            this._pstmt.setDouble(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setDouble(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBigDecimal(int index, BigDecimal value) throws SQLException {
        try {
            log.info(this._id + ":setBigDecimal(" + index + "," + value + ")");
            this._pstmt.setBigDecimal(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setBigDecimal(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setString(int index, String value) throws SQLException {
        try {
            log.info(this._id + ":setString(" + index + "," + value + ")");
            this._pstmt.setString(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setString(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBytes(int index, byte[] value) throws SQLException {
        try {
            log.info(this._id + ":setBytes(" + index + "," + value + ")");
            this._pstmt.setBytes(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setBytes(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDate(int index, Date value) throws SQLException {
        try {
            log.info(this._id + ":setDate(" + index + "," + value + ")");
            this._pstmt.setDate(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setDate(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDate(int index, Date value, Calendar cal) throws SQLException {
        try {
            log.info(this._id + ":setDate(" + index + "," + value + ",cal=" + cal + ")");
            this._pstmt.setDate(index, value, cal);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setDate(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTime(int index, Time value) throws SQLException {
        try {
            log.info(this._id + ":setTime(" + index + "," + value + ")");
            this._pstmt.setTime(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setTime(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTime(int index, Time value, Calendar cal) throws SQLException {
        try {
            log.info(this._id + ":setTime(" + index + "," + value + ",cal=" + cal + ")");
            this._pstmt.setTime(index, value, cal);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setTime(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTimestamp(int index, Timestamp value) throws SQLException {
        try {
            log.info(this._id + ":setTimestamp(" + index + "," + value + ")");
            this._pstmt.setTimestamp(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setTimestamp(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTimestamp(int index, Timestamp value, Calendar cal) throws SQLException {
        try {
            log.info(this._id + ":setTimestamp(" + index + "," + value + ",cal=" + cal + ")");
            this._pstmt.setTimestamp(index, value, cal);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setTimestamp(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setAsciiStream(int index, InputStream value, int length) throws SQLException {
        try {
            log.info(this._id + ":setAsciiStream(" + index + "," + value + ",len=" + length + ")");
            this._pstmt.setAsciiStream(index, value, length);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setAsciiStream(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setUnicodeStream(int index, InputStream value, int length) throws SQLException {
        try {
            log.info(this._id + ":setUnicodeStream(" + index + "," + value + ",len=" + length + ")");
            this._pstmt.setUnicodeStream(index, value, length);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setUnicodeStream(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBinaryStream(int index, InputStream value, int length) throws SQLException {
        try {
            log.info(this._id + ":setBinaryStream(" + index + "," + value + ",len=" + length + ")");
            this._pstmt.setBinaryStream(index, value, length);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setBinaryStream(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setCharacterStream(int index, Reader value, int length) throws SQLException {
        try {
            log.info(this._id + ":setCharacterStream(" + index + "," + value + ",len=" + length + ")");
            this._pstmt.setCharacterStream(index, value, length);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setCharacterStream(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value, int type, int scale) throws SQLException {
        try {
            log.info(this._id + ":setObject(" + index + "," + value + ",type=" + type + ",scale=" + scale + ")");
            this._pstmt.setObject(index, value, type, scale);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setObject(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value, int type) throws SQLException {
        try {
            log.info(this._id + ":setObject(" + index + "," + value + ",type=" + type + ")");
            this._pstmt.setObject(index, value, type);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setObject(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value) throws SQLException {
        try {
            log.info(this._id + ":setObject(" + index + "," + value + ")");
            this._pstmt.setObject(index, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.info(this._id + ":exn-setObject(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setRef(int index, Ref value) throws SQLException {
        try {
            log.info(this._id + ":setRef(" + index + "," + value + ")");
            this._pstmt.setRef(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setRef(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBlob(int index, Blob value) throws SQLException {
        try {
            log.info(this._id + ":setBlob(" + index + "," + value + ")");
            this._pstmt.setBlob(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setBlob(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setClob(int index, Clob value) throws SQLException {
        try {
            log.info(this._id + ":setClob(" + index + "," + value + ")");
            this._pstmt.setClob(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setClob(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setArray(int index, Array value) throws SQLException {
        try {
            log.info(this._id + ":setArray(" + index + "," + value + ")");
            this._pstmt.setArray(index, value);
        }
        catch (Throwable e) {
            log.info(this._id + ":exn-setArray(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setURL(int index, URL value) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

