/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;

public class SpyDriver
implements Driver {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyDriver"));
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyDriver"));
    private static int _staticId;
    private int _id;
    private int _connCount;
    private Driver _driver;

    public SpyDriver(Driver driver) {
        this._driver = driver;
        this._id = _staticId++;
    }

    public boolean acceptsURL(String url) throws SQLException {
        try {
            boolean result = this._driver.acceptsURL(url);
            log.info(this._id + ":acceptsURL(" + url + ") -> " + result);
            return result;
        }
        catch (SQLException e) {
            log.info(this._id + ":exn-acceptURL(" + e + ")");
            throw e;
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        try {
            Connection conn = this._driver.connect(url, info);
            int connId = this._connCount++;
            log.info(this._id + ":connect(" + url + ",info=" + info + ") -> " + connId + ":" + conn);
            return new SpyConnection(conn, connId);
        }
        catch (SQLException e) {
            log.info(this._id + ":exn-connect(" + e + ")");
            throw e;
        }
    }

    public int getMajorVersion() {
        int result = this._driver.getMajorVersion();
        log.info(this._id + ":getMajorVersion() -> " + result);
        return result;
    }

    public int getMinorVersion() {
        int result = this._driver.getMinorVersion();
        log.info(this._id + ":getMinorVersion() -> " + result);
        return result;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            DriverPropertyInfo[] result = this._driver.getPropertyInfo(url, info);
            Hashtable<Object, Object> cleanInfo = new Hashtable<Object, Object>(info);
            if (cleanInfo.get("password") != null) {
                cleanInfo.put("password", "****");
            }
            log.info(this._id + ":getPropertyInfo(" + url + ") -> " + result);
            return result;
        }
        catch (SQLException e) {
            log.info(this._id + ":exn-getPropertyInfo(" + e + ")");
            throw e;
        }
    }

    public boolean jdbcCompliant() {
        boolean result = this._driver.jdbcCompliant();
        log.info(this._id + ":jdbcCompliant() -> " + result);
        return result;
    }

    public String toString() {
        return "SpyDriver[id=" + this._id + ",driver=" + this._driver + "]";
    }
}

