/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.log.Log;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.StatementOverflowException;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserConnection
implements Connection {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/UserConnection"));
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/UserConnection"));
    private ManagedConnectionImpl _mConn;
    private Statement _statement;
    private ArrayList<SoftReference<Statement>> _statements;

    UserConnection(ManagedConnectionImpl mConn) {
        if (mConn == null || mConn.getDriverConnection() == null) {
            throw new NullPointerException();
        }
        this._mConn = mConn;
    }

    public Connection getConnection() throws SQLException {
        return this.getMConn().getDriverConnection();
    }

    void associate(ManagedConnectionImpl mConn) {
        this._mConn = mConn;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getMConn().prepareStatement(this, sql, -1);
        }
        catch (SQLException e) {
            this.getMConn().fatalEvent(e);
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getMConn().prepareStatement(this, sql, resultSetType);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareCall(sql);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt;
        if (this.getConnection() == null) {
            this.fatalEvent();
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getMConn().setCatalog(catalog);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getConnection().getTypeMap();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getMConn().setTypeMap(map);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.getConnection().nativeSQL(sql);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getConnection().getTransactionIsolation();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int isolation) throws SQLException {
        this.getMConn().setTransactionIsolation(isolation);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getConnection().getWarnings();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.getConnection().clearWarnings();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.getMConn().setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.getConnection().isReadOnly();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getMConn().setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        try {
            Connection conn = this.getConnection();
            if (conn != null) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            Connection conn = this.getConnection();
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.getMConn() == null || this.getConnection() == null || this.getConnection().isClosed();
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ManagedConnectionImpl mConn;
        UserConnection userConnection = this;
        synchronized (userConnection) {
            mConn = this._mConn;
            this._mConn = null;
            if (mConn == null) {
                return;
            }
        }
        try {
            this.resetConnection(mConn);
        }
        catch (Throwable e) {
            mConn.fatalEvent();
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SQLExceptionWrapper(e);
        }
        finally {
            mConn.closeEvent(this);
        }
    }

    private void addStatement(Statement stmt) {
        int maxCloseStatements = this._mConn.getDBPool().getMaxCloseStatements();
        if (this._statements == null || this._statements.size() < maxCloseStatements) {
            if (this._statement == null) {
                this._statement = stmt;
            } else if (this._statements == null) {
                this._statements = new ArrayList();
                this._statements.add(new SoftReference<Statement>(stmt));
            } else {
                this._statements.add(new SoftReference<Statement>(stmt));
            }
        } else {
            for (int i = this._statements.size() - 1; i >= 0; --i) {
                SoftReference<Statement> stmtRef = this._statements.get(i);
                if (stmtRef.get() != null) continue;
                this._statements.remove(i);
            }
            if (this._statements.size() < maxCloseStatements) {
                this._statements.add(new SoftReference<Statement>(stmt));
            } else {
                this.fatalEvent(new StatementOverflowException(L.l("too many statements {0} to automatically close.", new Integer(maxCloseStatements))));
            }
        }
    }

    @Override
    public void setHoldability(int hold) throws SQLException {
        this.getConnection().setHoldability(hold);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getConnection().getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getConnection().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getConnection().setSavepoint(name);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getConnection().releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getConnection().rollback(savepoint);
    }

    private void resetConnection(ManagedConnectionImpl mConn) {
        if (mConn == null) {
            return;
        }
        Connection conn = mConn.getDriverConnection();
        if (conn == null) {
            return;
        }
        this.closeStatements(mConn);
    }

    private void closeStatements(ManagedConnectionImpl mConn) {
        ArrayList<SoftReference<Statement>> statements = this._statements;
        this._statements = null;
        Statement stmt = this._statement;
        this._statement = null;
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        for (int i = 0; statements != null && i < statements.size(); ++i) {
            try {
                SoftReference<Statement> statementRef = statements.get(i);
                stmt = statementRef != null ? statementRef.get() : null;
                if (stmt == null) continue;
                stmt.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private ManagedConnectionImpl getMConn() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn == null) {
            throw new IllegalStateException("connection is closed");
        }
        return mConn;
    }

    private void fatalEvent() {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.fatalEvent();
        }
    }

    private void fatalEvent(SQLException exn) {
        ManagedConnectionImpl mConn = this._mConn;
        if (mConn != null) {
            mConn.fatalEvent(exn);
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        return "UserConnectionAdapter[]";
    }
}

