/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.log.Log;
import com.caucho.sql.Credential;
import com.caucho.sql.DBPoolImpl;
import com.caucho.sql.DriverConfig;
import com.caucho.sql.ManagedFactoryImpl;
import com.caucho.sql.PreparedStatementCacheItem;
import com.caucho.sql.PreparedStatementKey;
import com.caucho.sql.UserConnection;
import com.caucho.sql.UserPreparedStatement;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.sql.ConnectionEvent;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class ManagedConnectionImpl
implements ManagedConnection,
javax.sql.ConnectionEventListener {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/ManagedConnectionImpl"));
    protected static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/ManagedConnectionImpl"));
    private ManagedFactoryImpl _factory;
    private DriverConfig _driver;
    private Credential _credentials;
    private PooledConnection _pooledConnection;
    private Connection _driverConnection;
    private XAResource _xaResource;
    private LocalTransaction _localTransaction;
    private ConnectionEventListener _listener;
    private javax.resource.spi.ConnectionEvent _connClosedEvent;
    private ResourceException _connException;
    private long _lastEventTime;
    private LruCache<PreparedStatementKey, PreparedStatementCacheItem> _preparedStatementCache;
    private PreparedStatementKey _key;
    private int _isolation = -1;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private String _catalog = null;
    private int _oldIsolation = -1;
    private Map _typeMap;

    ManagedConnectionImpl(ManagedFactoryImpl factory, DriverConfig driver, Credential credentials) throws SQLException {
        this._factory = factory;
        this._driver = driver;
        this._credentials = credentials;
        this._connClosedEvent = new javax.resource.spi.ConnectionEvent((ManagedConnection)this, 1);
        this.initDriverConnection();
        this._lastEventTime = Alarm.getCurrentTime();
        DBPoolImpl dbPool = factory.getDBPool();
        int preparedStatementCacheSize = dbPool.getPreparedStatementCacheSize();
        if (preparedStatementCacheSize > 0) {
            this._preparedStatementCache = new LruCache(preparedStatementCacheSize);
            this._key = new PreparedStatementKey();
        }
    }

    DBPoolImpl getDBPool() {
        return this._factory.getDBPool();
    }

    Credential getCredentials() {
        return this._credentials;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (this._connException != null) {
            throw this._connException;
        }
        this.ping();
        this._lastEventTime = Alarm.getCurrentTime();
        return new UserConnection(this);
    }

    public void associateConnection(Object connection) throws ResourceException {
        this._lastEventTime = Alarm.getCurrentTime();
        UserConnection uConn = (UserConnection)connection;
        uConn.associate(this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this._listener != null && this._listener != listener) {
            throw new IllegalStateException();
        }
        this._listener = listener;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this._listener == listener) {
            this._listener = null;
        }
    }

    private void initDriverConnection() throws SQLException {
        if (this._driverConnection != null) {
            throw new IllegalStateException();
        }
        String user = this._driver.getUser();
        String password = this._driver.getPassword();
        if (this._credentials != null) {
            user = this._credentials.getUserName();
            password = this._credentials.getPassword();
        }
        this._pooledConnection = this._driver.createPooledConnection(user, password);
        if (this._pooledConnection != null) {
            this._pooledConnection.addConnectionEventListener(this);
            this._driverConnection = this._pooledConnection.getConnection();
        } else {
            this._driverConnection = this._driver.createDriverConnection(user, password);
        }
        if (this._driverConnection == null) {
            throw new SQLException(L.l("Failed to create driver connection."));
        }
        DBPoolImpl dbPool = this._factory.getDBPool();
        long transactionTimeout = dbPool.getTransactionTimeout();
        if (transactionTimeout > 0L && this._pooledConnection instanceof XAConnection) {
            try {
                XAResource xaResource = ((XAConnection)this._pooledConnection).getXAResource();
                xaResource.setTransactionTimeout((int)(transactionTimeout / 1000L));
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (dbPool.isSpy()) {
            this._driverConnection = new SpyConnection(this._driverConnection, dbPool.newSpyId());
        }
    }

    Connection getDriverConnection() {
        return this._driverConnection;
    }

    public XAResource getXAResource() throws ResourceException {
        try {
            if (this._pooledConnection instanceof XAConnection) {
                return ((XAConnection)this._pooledConnection).getXAResource();
            }
        }
        catch (SQLException e) {
            throw new ResourceException((Throwable)e);
        }
        throw new NotSupportedException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (this._pooledConnection instanceof XAConnection && this._pooledConnection.getClass().getName().startsWith("oracle")) {
            throw new NotSupportedException(L.l("Oracle does not allow local transactions"));
        }
        if (this._localTransaction == null) {
            this._localTransaction = new LocalTransactionImpl();
        }
        return this._localTransaction;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new NotSupportedException();
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public void setIsolation(int isolation) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareStatement(UserConnection uConn, String sql, int resultType) throws SQLException {
        UserPreparedStatement upStmt;
        PreparedStatementCacheItem item;
        PreparedStatementKey key = this._key;
        Connection conn = this.getDriverConnection();
        if (conn == null) {
            throw new IllegalStateException(L.l("can't prepare statement from closed connection"));
        }
        if (key == null) {
            if (resultType > 0) {
                return conn.prepareStatement(sql, resultType);
            }
            return conn.prepareStatement(sql);
        }
        boolean hasItem = false;
        PreparedStatementKey preparedStatementKey = key;
        synchronized (preparedStatementKey) {
            key.init(sql, resultType);
            item = this._preparedStatementCache.get(key);
            if (item != null) {
                upStmt = item.toActive(uConn);
                if (upStmt != null) {
                    return upStmt;
                }
                hasItem = !item.isRemoved();
            }
        }
        PreparedStatement pStmt = resultType > 0 ? conn.prepareStatement(sql, resultType) : conn.prepareStatement(sql);
        if (hasItem) {
            return pStmt;
        }
        key = new PreparedStatementKey(sql, resultType);
        item = new PreparedStatementCacheItem(key, pStmt, this);
        upStmt = item.toActive(uConn);
        if (upStmt == null) {
            throw new IllegalStateException("preparedStatement can't activate");
        }
        this._preparedStatementCache.put(key, item);
        return upStmt;
    }

    void remove(PreparedStatementKey key) {
        this._preparedStatementCache.remove(key);
    }

    public void connectionClosed(ConnectionEvent event) {
        this.sendFatalEvent(new SQLException(L.l("unexpected close event from pool")));
        this.closeEvent(null);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this.sendFatalEvent(event.getSQLException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEvent(UserConnection userConn) {
        if (this._listener != null) {
            javax.resource.spi.ConnectionEvent evt;
            if (this._connException != null) {
                this.sendFatalEvent((Exception)((Object)this._connException));
            }
            ManagedConnectionImpl managedConnectionImpl = this;
            synchronized (managedConnectionImpl) {
                evt = this._connClosedEvent;
                this._connClosedEvent = null;
            }
            if (evt == null) {
                evt = new javax.resource.spi.ConnectionEvent((ManagedConnection)this, 1);
            }
            evt.setConnectionHandle((Object)userConn);
            this._listener.connectionClosed(evt);
            evt.setConnectionHandle(null);
            this._connClosedEvent = evt;
            this._lastEventTime = Alarm.getCurrentTime();
        }
    }

    public void fatalEvent() {
        this.fatalEvent((Exception)((Object)new ResourceException("fatal event")));
    }

    public void fatalEvent(Exception e) {
        if (this._pooledConnection == null) {
            this._connException = e instanceof ResourceException ? (ResourceException)((Object)e) : new ResourceException((Throwable)e);
        }
    }

    public void sendFatalEvent(Exception e) {
        if (this._listener != null) {
            javax.resource.spi.ConnectionEvent event = new javax.resource.spi.ConnectionEvent((ManagedConnection)this, 5, e);
            this._listener.connectionErrorOccurred(event);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this._autoCommit = autoCommit;
            this._driverConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this._readOnly = readOnly;
            this._driverConnection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            if (this._catalog == null) {
                this._catalog = this._driverConnection.getCatalog();
            }
            this._driverConnection.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.fatalEvent();
            throw e;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this._typeMap == null) {
            this._typeMap = this._driverConnection.getTypeMap();
        }
        this._driverConnection.setTypeMap(map);
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        this._oldIsolation = this._driverConnection.getTransactionIsolation();
        this._isolation = isolation;
        this._driverConnection.setTransactionIsolation(isolation);
    }

    public void cleanup() throws ResourceException {
        Connection conn = this._driverConnection;
        if (conn == null) {
            return;
        }
        try {
            if (!this._autoCommit) {
                conn.rollback();
                conn.setAutoCommit(true);
            }
            this._autoCommit = true;
            if (this._readOnly) {
                conn.setReadOnly(false);
            }
            this._readOnly = false;
            if (this._catalog != null) {
                conn.setCatalog(this._catalog);
            }
            this._catalog = null;
            if (this._typeMap != null) {
                conn.setTypeMap(this._typeMap);
            }
            this._typeMap = null;
            if (this._isolation != this._oldIsolation) {
                conn.setTransactionIsolation(this._oldIsolation);
            }
            this._isolation = this._oldIsolation;
            conn.clearWarnings();
        }
        catch (SQLException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    boolean isValid() {
        try {
            this.ping();
            return true;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ping() throws ResourceException {
        DBPoolImpl dbPool = this._factory.getDBPool();
        long now = Alarm.getCurrentTime();
        if (now < this._lastEventTime + 1000L) {
            return;
        }
        if (!dbPool.isPing()) {
            return;
        }
        long pingInterval = dbPool.getPingInterval();
        if (pingInterval > 0L && now < this._lastEventTime + pingInterval) {
            return;
        }
        String pingQuery = dbPool.getPingQuery();
        if (pingQuery == null) {
            return;
        }
        if (this._driverConnection == null) {
            return;
        }
        try {
            Statement stmt = this._driverConnection.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(pingQuery);
                rs.close();
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public void destroy() throws ResourceException {
        log.finer("destroy " + this);
        PooledConnection poolConn = this._pooledConnection;
        this._pooledConnection = null;
        Connection driverConn = this._driverConnection;
        this._driverConnection = null;
        if (this._preparedStatementCache != null) {
            Iterator<PreparedStatementCacheItem> iter = this._preparedStatementCache.values();
            while (iter.hasNext()) {
                PreparedStatementCacheItem item = iter.next();
                item.destroy();
            }
        }
        try {
            if (poolConn != null) {
                poolConn.close();
                driverConn = null;
            }
        }
        catch (SQLException e) {
            throw new ResourceException((Throwable)e);
        }
        try {
            if (driverConn != null) {
                driverConn.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    class LocalTransactionImpl
    implements LocalTransaction {
        private boolean _oldAutoCommit;

        LocalTransactionImpl() {
        }

        public void begin() throws ResourceException {
            try {
                this._oldAutoCommit = ManagedConnectionImpl.this._autoCommit;
                ManagedConnectionImpl.this.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new ResourceException((Throwable)e);
            }
        }

        public void commit() throws ResourceException {
            Connection conn = ManagedConnectionImpl.this._driverConnection;
            if (conn == null) {
                throw new ResourceException(L.l("connection is closed"));
            }
            try {
                conn.commit();
            }
            catch (SQLException e) {
                throw new ResourceException((Throwable)e);
            }
            try {
                ManagedConnectionImpl.this.setAutoCommit(this._oldAutoCommit);
            }
            catch (SQLException e) {
                throw new ResourceException((Throwable)e);
            }
        }

        public void rollback() throws ResourceException {
            Connection conn = ManagedConnectionImpl.this._driverConnection;
            if (conn == null) {
                throw new ResourceException(L.l("connection is closed"));
            }
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                throw new ResourceException((Throwable)e);
            }
            try {
                ManagedConnectionImpl.this.setAutoCommit(this._oldAutoCommit);
            }
            catch (SQLException e) {
                throw new ResourceException((Throwable)e);
            }
        }
    }
}

