/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.StringAttributeProgram;
import com.caucho.config.TypeBuilderFactory;
import com.caucho.config.types.InitParam;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.sql.DBPoolImpl;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class DriverConfig {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/DriverConfig"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/DriverConfig"));
    private static final String URL_PREFIX = "jdbc:caucho:";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    private DBPoolImpl _dbPool;
    private ManagedConnectionFactory _mcf;
    private Class _driverClass;
    private String _driverURL;
    private String _user;
    private String _password;
    private Properties _info;
    private BuilderProgramContainer _init = new BuilderProgramContainer();
    private Object _driverObject;
    private ConnectionPoolDataSource _poolDataSource;
    private XADataSource _xaDataSource;
    private Driver _driver;
    private boolean _isInit;
    private boolean _isStarted;

    public DriverConfig(DBPoolImpl pool) {
        this._dbPool = pool;
        this._info = new Properties();
    }

    public DBPoolImpl getDBPool() {
        return this._dbPool;
    }

    public void setDataSource(Object dataSource) throws ConfigException {
        if (dataSource instanceof String) {
            dataSource = Jndi.lookup((String)dataSource);
        }
        if (dataSource instanceof XADataSource) {
            this._xaDataSource = (XADataSource)dataSource;
        } else if (dataSource instanceof ConnectionPoolDataSource) {
            this._poolDataSource = (ConnectionPoolDataSource)dataSource;
        } else {
            throw new ConfigException(L.l("data-source `{0}' is of type `{1}' which does not implement XADataSource or ConnectionPoolDataSource.", dataSource, dataSource.getClass().getName()));
        }
    }

    public Class getDriverClass() {
        return this._driverClass;
    }

    public XADataSource getXADataSource() {
        return this._xaDataSource;
    }

    public void setType(Class driverClass) throws ConfigException {
        this._driverClass = driverClass;
        if (!(ClassLiteral.getClass((String)"java/sql/Driver").isAssignableFrom(driverClass) || ClassLiteral.getClass((String)"javax/sql/XADataSource").isAssignableFrom(driverClass) || ClassLiteral.getClass((String)"javax/sql/ConnectionPoolDataSource").isAssignableFrom(driverClass))) {
            throw new ConfigException(L.l("`{0}' is not a valid database type.", driverClass.getName()));
        }
        Config.checkCanInstantiate(driverClass);
    }

    public String getURL() {
        return this._driverURL;
    }

    public void setURL(String url) {
        this._driverURL = url;
    }

    public void addBuilderProgram(BuilderProgram program) {
        this._init.addProgram(program);
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setInitParam(InitParam initParam) {
        HashMap<String, String> paramMap = initParam.getParameters();
        Iterator<String> iter = paramMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            this._info.setProperty(key, paramMap.get(key));
        }
    }

    public void setInitParam(String key, String value) {
        this._info.setProperty(key, value);
    }

    public Properties getInfo() {
        return this._info;
    }

    public Driver getDriver() throws SQLException {
        Object obj = this.getDriverObject();
        if (obj instanceof Driver) {
            return (Driver)obj;
        }
        return null;
    }

    public ConnectionPoolDataSource getPoolDataSource() throws SQLException {
        return this._poolDataSource;
    }

    synchronized void initDataSource(boolean isTransactional, boolean isSpy) throws SQLException {
        if (this._isStarted) {
            return;
        }
        this._isStarted = true;
        if (this._xaDataSource == null && this._poolDataSource == null) {
            this.initDriver();
            Object driverObject = this.getDriverObject();
            if (driverObject == null) {
                throw new SQLExceptionWrapper(L.l("driver `{0}' has not been configured for pool {1}.  <database> needs a <driver type='...'>.", (Object)this._driverClass, this.getDBPool().getName()));
            }
            if (driverObject instanceof XADataSource) {
                this._xaDataSource = (XADataSource)this._driverObject;
            } else if (this._driverObject instanceof ConnectionPoolDataSource) {
                this._poolDataSource = (ConnectionPoolDataSource)this._driverObject;
            } else if (this._driverObject instanceof Driver) {
                this._driver = (Driver)this._driverObject;
            } else {
                throw new SQLExceptionWrapper(L.l("driver `{0}' has not been configured for pool {1}.  <database> needs a <driver type='...'>.", (Object)this._driverClass, this.getDBPool().getName()));
            }
            if (!isTransactional && this._xaDataSource != null) {
                throw new SQLExceptionWrapper(L.l("XADataSource `{0}' must be configured as transactional.  Either configure it with <xa>true</xa> or use the database's ConnectionPoolDataSource driver or the old java.sql.Driver driver.", this._xaDataSource));
            }
        }
    }

    synchronized Object getDriverObject() throws SQLException {
        if (this._driverObject != null) {
            return this._driverObject;
        }
        if (this._driverClass == null) {
            return null;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("loading driver: " + this._driverClass.getName());
        }
        try {
            this._driverObject = this._driverClass.newInstance();
        }
        catch (Exception e) {
            throw new SQLExceptionWrapper(e);
        }
        return this._driverObject;
    }

    PooledConnection createPooledConnection(String user, String password) throws SQLException {
        PooledConnection conn = null;
        if (this._xaDataSource != null) {
            conn = user == null && password == null ? this._xaDataSource.getXAConnection() : this._xaDataSource.getXAConnection(user, password);
        } else if (this._poolDataSource != null) {
            conn = user == null && password == null ? this._poolDataSource.getPooledConnection() : this._poolDataSource.getPooledConnection(user, password);
        }
        return conn;
    }

    Connection createDriverConnection(String user, String password) throws SQLException {
        if (this._xaDataSource != null || this._poolDataSource != null) {
            throw new IllegalStateException();
        }
        if (this._driver == null) {
            throw new IllegalStateException();
        }
        Driver driver = this._driver;
        String url = this.getURL();
        if (url == null) {
            throw new SQLException(L.l("can't create connection with null url"));
        }
        Properties properties = this.getInfo();
        if (user != null) {
            properties.put(PROPERTY_USER, user);
        } else {
            properties.put(PROPERTY_USER, "");
        }
        if (password != null) {
            properties.put(PROPERTY_PASSWORD, password);
        } else {
            properties.put(PROPERTY_PASSWORD, "");
        }
        Connection conn = driver != null ? driver.connect(url, properties) : DriverManager.getConnection(url, properties);
        return conn;
    }

    public void initDriver() throws SQLException {
        StringAttributeProgram program;
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        Object driverObject = this.getDriverObject();
        if (driverObject == null) {
            if (this._xaDataSource != null || this._poolDataSource != null) {
                return;
            }
            throw new SQLExceptionWrapper(L.l("driver `{0}' has not been configured for pool {1}.  <database> needs either a <data-source> or a <type>.", (Object)this._driverClass, this.getDBPool().getName()));
        }
        try {
            if (this._driverURL != null && !(driverObject instanceof Driver)) {
                program = new StringAttributeProgram("url", this._driverURL);
                program.configure(driverObject);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            throw new SQLExceptionWrapper(e);
        }
        try {
            if (this._user != null && !(driverObject instanceof Driver)) {
                program = new StringAttributeProgram(PROPERTY_USER, this._user);
                program.configure(driverObject);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
            throw new SQLExceptionWrapper(e);
        }
        try {
            if (this._password != null && !(driverObject instanceof Driver)) {
                program = new StringAttributeProgram(PROPERTY_PASSWORD, this._password);
                program.configure(driverObject);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
            throw new SQLExceptionWrapper(e);
        }
        try {
            if (this._init != null) {
                this._init.configure(driverObject);
                this._init = null;
            }
            TypeBuilderFactory.init(driverObject);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            throw new SQLExceptionWrapper(e);
        }
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        return this._mcf;
    }

    public String toString() {
        return "Driver[" + this._driverClass + "]";
    }
}

