/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.log.Log;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppRegexpDeploy
extends Deploy<WebAppEntry> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/WebAppSingleDeploy"));
    private ApplicationContainer _container;
    private WebAppEntry _parent;
    private WebAppConfig _config;
    private ArrayList<WebAppConfig> _webAppDefaults = new ArrayList();
    private ArrayList<WebAppEntry> _entries = new ArrayList();

    public WebAppRegexpDeploy(DeployContainer<WebAppEntry> deployContainer) {
        super(deployContainer);
    }

    public WebAppRegexpDeploy(DeployContainer<WebAppEntry> deployContainer, ApplicationContainer container, WebAppConfig config) {
        super(deployContainer);
        this.setContainer(container);
        this._config = config;
    }

    public ApplicationContainer getContainer() {
        return this._container;
    }

    public void setContainer(ApplicationContainer container) {
        this._container = container;
    }

    public void setParent(WebAppEntry parent) {
        this._parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WebAppEntry generateEntry(String name) {
        Pattern regexp = this._config.getURLRegexp();
        Matcher matcher = regexp.matcher(name);
        if (!matcher.find()) return null;
        if (matcher.start() != 0) {
            return null;
        }
        int length = matcher.end() - matcher.start();
        String contextPath = matcher.group();
        ArrayList<String> vars = new ArrayList<String>();
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        for (int j = 0; j <= matcher.groupCount(); ++j) {
            vars.add(matcher.group(j));
            varMap.put(new StringBuffer().append("app").append(j).toString(), matcher.group(j));
        }
        varMap.put("regexp", vars);
        Path appDir = null;
        try {
            String appDirPath = this._config.getDocumentDirectory();
            if (appDirPath == null) {
                appDirPath = new StringBuffer().append("./").append(matcher.group(0)).toString();
            }
            if (!(appDir = PathBuilder.lookupPath(appDirPath, varMap)).canRead()) {
                return null;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
        WebAppEntry entry = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            ArrayList<WebAppEntry> arrayList = this._entries;
            synchronized (arrayList) {
                int i;
                for (i = 0; i < this._entries.size(); ++i) {
                    entry = this._entries.get(i);
                    if (!appDir.equals(entry.getRootDirectory())) continue;
                    WebAppEntry webAppEntry = entry;
                    return webAppEntry;
                }
                entry = new WebAppEntry(this._container, name);
                entry.setRootDirectory(appDir);
                entry.getVariableMap().putAll(varMap);
                entry.setRegexpValues(vars);
                entry.setWebAppConfig(this._config);
                for (i = 0; i < this._webAppDefaults.size(); ++i) {
                    entry.addWebAppDefault(this._webAppDefaults.get(i));
                }
                this._entries.add(entry);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        entry.setSourceType("regexp");
        return entry;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return new StringBuffer().append("WebAppRegexpDeploy[").append(this._config.getURLRegexp().pattern()).append("]").toString();
    }
}

