/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.log.Log;
import com.caucho.server.security.NullAuthenticator;
import com.caucho.server.security.ServletAuthenticator;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractLogin {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/security/AbstractLogin"));
    protected ServletAuthenticator _auth;

    public void setAuthenticator(ServletAuthenticator auth) {
        this._auth = auth;
    }

    public ServletAuthenticator getAuthenticator() {
        if (this._auth == null) {
            try {
                InitialContext ic = new InitialContext();
                this._auth = (ServletAuthenticator)ic.lookup("java:comp/env/caucho/auth");
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            if (this._auth == null) {
                this._auth = new NullAuthenticator();
            }
        }
        return this._auth;
    }

    public void init() throws ServletException {
    }

    public String getAuthType() {
        return "none";
    }

    public Principal authenticate(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        Principal user = this.getUserPrincipal(request, response, application);
        if (user == null) {
            response.sendError(403);
        }
        return user;
    }

    public Principal getUserPrincipal(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        return this.getAuthenticator().getUserPrincipal(request, response, application);
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user, String role) throws ServletException {
        return this.getAuthenticator().isUserInRole(request, response, application, user, role);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        Principal principal = this.getUserPrincipal(request, response, application);
        if (principal != null) {
            this.getAuthenticator().logout(application, request.getRequestedSessionId(), principal);
        }
    }
}

