/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.Version;
import com.caucho.config.ConfigException;
import com.caucho.config.NodeBuilder;
import com.caucho.license.LicenseCheck;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.server.resin.ResinServer;
import com.caucho.server.resin.ResinServerListener;
import com.caucho.util.Alarm;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.EnvironmentStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.RotateStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resin
implements ResinServerListener {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/resin/Resin"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/resin/Resin"));
    private String _resinConf = "conf/resin.conf";
    private String _serverId;
    private ClassLoader _systemClassLoader = Thread.currentThread().getContextClassLoader();
    private Thread _mainThread;
    private ResinServer _server;
    private EnvironmentClassLoader _classLoader;
    private long _startTime = Alarm.getCurrentTime();
    private volatile boolean _isClosed;
    private volatile boolean _isRestarting;
    private InputStream _waitIn;

    public Resin(String[] argv) throws Exception {
        this.parseCommandLine(argv);
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public ResinServer getServer() {
        return this._server;
    }

    private void parseCommandLine(String[] argv) throws Exception {
        int len = argv.length;
        int i = 0;
        while (i < len) {
            RotateStream stream;
            RandomUtil.addRandom(argv[i]);
            if (i + 1 < len && (argv[i].equals("-stdout") || argv[i].equals("--stdout"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                stream.setRolloverPeriod(604800000L);
                WriteStream out = stream.getStream();
                out.setDisableClose(true);
                EnvironmentStream.setStdout(out);
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-stderr") || argv[i].equals("--stderr"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                stream.setRolloverPeriod(604800000L);
                WriteStream out = stream.getStream();
                out.setDisableClose(true);
                EnvironmentStream.setStderr(out);
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-conf")) {
                this._resinConf = argv[i + 1];
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-server")) {
                this._serverId = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-version")) {
                System.out.println(Version.FULL_VERSION);
                System.exit(66);
                continue;
            }
            if (argv[i].equals("-socketwait")) {
                int socketport = Integer.parseInt(argv[i + 1]);
                Socket socket = null;
                for (int k = 0; k < 15 && socket == null; ++k) {
                    try {
                        socket = new Socket("127.0.0.1", socketport);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (socket != null) continue;
                    Thread.sleep(1000L);
                }
                if (socket == null) {
                    System.err.println("Can't connect to parent process through socket " + socket);
                    System.err.println("Resin needs to connect to its parent.");
                    System.exit(0);
                }
                this._waitIn = socket.getInputStream();
                socket.setSoTimeout(10000);
                i += 2;
                continue;
            }
            System.out.println(L.l("unknown argument `{0}'", argv[i]));
            System.out.println();
            Resin.usage();
            System.exit(66);
        }
    }

    private static void usage() {
        System.err.println(L.l("usage: Resin [-conf resin.conf] [-server id]"));
    }

    public void init() throws Throwable {
        this._mainThread = Thread.currentThread();
        this._mainThread.setContextClassLoader(this._systemClassLoader);
        this.addRandom();
        System.out.println(Version.FULL_VERSION);
        System.out.println("Copyright(c) 1998-2004 Caucho Technology.  All rights reserved.");
        System.out.println();
        try {
            Class<?> cl = Class.forName("com.caucho.license.LicenseCheckImpl", false, ClassLoader.getSystemClassLoader());
            LicenseCheck license = (LicenseCheck)cl.newInstance();
            try {
                license.validate(1);
                System.setProperty("isResinProfessional", "true");
                license.doLogging(1);
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                String msg = L.l("  No valid Resin(R) Professional license found.\n\nUsing Resin Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional.\n");
                log.warning(msg);
                System.err.println(msg);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            String msg = L.l("  Using Resin(R) Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional.\n");
            log.warning(msg);
            System.err.println(msg);
        }
        System.out.println("Starting Resin on " + QDate.formatLocal(Alarm.getCurrentTime()));
        System.out.println();
        EnvironmentClassLoader.initializeEnvironment();
        if (this._classLoader != null) {
            this._mainThread.setContextClassLoader(this._classLoader);
        }
        ResinServer server = new ResinServer();
        Path resinConf = Vfs.lookup(this._resinConf);
        server.setInitialStartTime(this._startTime);
        server.setConfigFile(resinConf.getNativePath());
        server.setServerId(this._serverId);
        server.addListener(this);
        NodeBuilder builder = new NodeBuilder();
        builder.setSchema(server.getSchema());
        this._mainThread.setContextClassLoader(this._systemClassLoader);
        builder.configure((Object)server, Vfs.lookup(this._resinConf));
        this._server = server;
        server.start();
    }

    private void addRandom() {
        RandomUtil.addRandom(System.currentTimeMillis());
        RandomUtil.addRandom(Runtime.getRuntime().freeMemory());
        RandomUtil.addRandom(System.identityHashCode(this._mainThread));
        RandomUtil.addRandom(System.identityHashCode(this._systemClassLoader));
        RandomUtil.addRandom(Version.FULL_VERSION);
        try {
            RandomUtil.addRandom(InetAddress.getLocalHost().toString());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            FileInputStream is = new FileInputStream("/dev/urandom");
            for (int i = 0; i < 16; ++i) {
                RandomUtil.addRandom(((InputStream)is).read());
            }
            ((InputStream)is).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RandomUtil.addRandom(System.currentTimeMillis());
    }

    public void closeEvent(ResinServer server) {
        try {
            if (this._waitIn == null) {
                this._isRestarting = true;
                this._server = null;
                log.info("restarting Resin");
                this.init();
            } else {
                this._isClosed = true;
            }
        }
        catch (Throwable e) {
            this._isClosed = true;
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        ResinServer server;
        int socketExceptionCount = 0;
        Runtime runtime = Runtime.getRuntime();
        while (!this._isClosed && (this._isRestarting || (server = this._server) != null && !server.isClosed())) {
            try {
                long systemTime;
                Thread.sleep(10L);
                if (this._isRestarting) continue;
                long minFreeMemory = this._server.getMinFreeMemory();
                if (minFreeMemory > 0L && 2L * minFreeMemory >= Resin.getFreeMemory(runtime)) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(L.l("free memory {0} max:{1} total:{2} free:{3}", "" + Resin.getFreeMemory(runtime), "" + runtime.maxMemory(), "" + runtime.totalMemory(), "" + runtime.freeMemory()));
                    }
                    log.info(L.l("Forcing GC due to low memory. {0} free bytes.", Resin.getFreeMemory(runtime)));
                    runtime.gc();
                    if (Resin.getFreeMemory(runtime) < minFreeMemory) {
                        this._isClosed = true;
                        log.severe(L.l("Restarting due to low free memory. {0} free bytes", Resin.getFreeMemory(runtime)));
                        return;
                    }
                }
                Integer memoryTest = new Integer(0);
                long alarmTime = Alarm.getCurrentTime();
                long diff = alarmTime - (systemTime = System.currentTimeMillis());
                if (diff < 0L) {
                    diff = -diff;
                }
                if (600000L < diff) {
                    log.severe(L.l("Restarting due to frozen Alarm thread"));
                    System.exit(1);
                }
                if (this._waitIn != null) {
                    int len = this._waitIn.read();
                    if (len >= 0) {
                        socketExceptionCount = 0;
                    }
                    this._isClosed = true;
                    continue;
                }
                Thread.sleep(10000L);
            }
            catch (SocketTimeoutException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedIOException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedException e) {
                socketExceptionCount = 0;
            }
            catch (SocketException e) {
                if (socketExceptionCount++ == 0) {
                    log.log(Level.FINE, e.toString(), e);
                    continue;
                }
                if (socketExceptionCount <= 100) continue;
                this._isClosed = true;
            }
            catch (OutOfMemoryError e) {
                this._isClosed = true;
                try {
                    System.err.println("Out of memory");
                }
                finally {
                    System.exit(1);
                }
            }
            catch (Throwable e) {
                this._isClosed = true;
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private static long getFreeMemory(Runtime runtime) {
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        if (maxMemory < totalMemory) {
            return freeMemory;
        }
        return maxMemory - totalMemory + freeMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            Resin.validateEnvironment();
            Resin resin = new Resin(argv);
            resin.init();
            resin.waitForExit();
            System.err.println(L.l("closing server"));
            final ResinServer server = resin.getServer();
            new Thread(){

                public void run() {
                    if (server != null) {
                        server.destroy();
                    }
                }
            }.start();
            for (int i = 0; i < 150 && server != null && !server.isClosed(); ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            System.exit(0);
        }
        catch (BindException e) {
            System.out.println(e);
            log.log(Level.FINE, e.toString(), e);
            System.exit(67);
        }
        catch (Throwable e) {
            boolean isCompile = false;
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof CompileException)) continue;
                System.err.println(cause.getMessage());
                isCompile = true;
                break;
            }
            if (!isCompile) {
                e.printStackTrace(System.err);
            } else {
                log.log(Level.CONFIG, e.toString(), e);
            }
        }
        finally {
            System.exit(1);
        }
    }

    private static void validateEnvironment() throws ConfigException {
        String loggingManager = System.getProperty("java.util.logging.manager");
        if (loggingManager == null || !loggingManager.equals("com.caucho.log.LogManagerImpl")) {
            throw new ConfigException(L.l("The following system property must be set:\n  -Djava.util.logging.manager=com.caucho.log.LogManagerImpl\nThe JDK 1.4 Logging manager must be set to Resin's log manager."));
        }
        Resin.validatePackage("javax.servlet.Servlet", new String[]{"2.4", "1.4"});
        Resin.validatePackage("javax.servlet.jsp.jstl.core.Config", new String[]{"1.1"});
        Resin.validatePackage("javax.management.MBeanServer", new String[]{"1.2", "1.4"});
        Resin.validatePackage("javax.resource.spi.ResourceAdapter", new String[]{"1.5", "1.4"});
    }

    private static void validatePackage(String className, String[] versions) throws ConfigException {
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
        }
        catch (Throwable e) {
            throw new ConfigException(L.l("class {0} is not loadable on startup.  Resin requires {0} to be in the classpath on startup.", className));
        }
        Package pkg = cl.getPackage();
        if (pkg == null) {
            throw new ConfigException(L.l("package for class {0} is missing.  Resin requires class {0} in the classpath on startup.", className));
        }
        if (pkg.getSpecificationVersion() == null) {
            throw new ConfigException(L.l("{0} has no specification version.  Resin {1} requires version {2}.", pkg, Version.VERSION, versions[0]));
        }
        for (int i = 0; i < versions.length; ++i) {
            if (!versions[i].equals(pkg.getSpecificationVersion())) continue;
            return;
        }
        throw new ConfigException(L.l("Specification version {0} of {1} is not compatible with Resin {2}.  Resin {2} requires version {3}.", pkg.getSpecificationVersion(), pkg, Version.VERSION, versions[0]));
    }

    public class ResinContainer {
        private ResinServer _resin;

        public ResinContainer(ResinServer resin2) {
            this._resin = resin2;
        }

        public ResinServer createResin() {
            return this._resin;
        }

        public ResinServer createCauchoCom() {
            return this._resin;
        }
    }
}

