/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.http.RunnerRequest;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.http.Cookie;

public class RunnerResponse
extends AbstractHttpResponse {
    RunnerRequest _req;

    RunnerResponse(RunnerRequest request) {
        super(request);
        this._req = request;
    }

    public boolean isTop() {
        if (!(this._request instanceof AbstractHttpRequest)) {
            return false;
        }
        return ((AbstractHttpRequest)this._request).isTop();
    }

    protected boolean writeHeadersInt(WriteStream os, int length) throws IOException {
        CharBuffer cb = this._cb;
        cb.clear();
        int version = this._req.getVersion();
        if (version >= 257) {
            cb.append("HTTP/1.1 ");
        } else {
            cb.append("HTTP/1.0 ");
        }
        cb.append((char)(this._statusCode / 100 % 10 + 48));
        cb.append((char)(this._statusCode / 10 % 10 + 48));
        cb.append((char)(this._statusCode % 10 + 48));
        cb.append(' ');
        cb.append(this._statusMessage);
        this._req.writeStatus(cb);
        if (this._statusCode >= 400) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
        } else if (this._isNoCache) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            this._req.writeHeader("Cache-Control", "no-cache");
        } else if (this.isPrivateCache()) {
            this._req.writeHeader("Cache-Control", "private");
        }
        for (int i = 0; i < this._headerKeys.size(); ++i) {
            String key = (String)this._headerKeys.get(i);
            String value = (String)this._headerValues.get(i);
            this._req.writeHeader(key, value);
        }
        if (this._contentLength >= 0L) {
            cb.clear();
            cb.append(this._contentLength);
            this._req.writeHeader("Content-Length", cb);
        } else if (length >= 0) {
            cb.clear();
            cb.append(length);
            this._req.writeHeader("Content-Length", cb);
        }
        long now = Alarm.getCurrentTime();
        for (int i = 0; i < this._cookiesOut.size(); ++i) {
            Cookie cookie = (Cookie)this._cookiesOut.get(i);
            int cookieVersion = cookie.getVersion();
            this.fillCookie(cb, cookie, now, 0);
            this._req.writeHeader("Set-Cookie", cb);
            if (cookieVersion <= 0) continue;
            this.fillCookie(cb, cookie, now, cookieVersion);
            this._req.writeHeader("Set-Cookie2", cb);
        }
        if (this._contentType != null) {
            this._req.writeHeader("Content-Type", this._contentType);
        }
        this._req.sendHeader();
        return false;
    }
}

