/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

public class JniStream
extends StreamImpl {
    private static boolean hasInitJni;
    private static NullPath nullPath;
    private int fd;
    private boolean flushOnNewline;
    private boolean closeChildOnClose = true;

    native int readNative(int var1, byte[] var2, int var3, int var4) throws IOException;

    native int writeNative(int var1, byte[] var2, int var3, int var4) throws IOException;

    native int flushNative(int var1) throws IOException;

    public JniStream(int fd) {
        if (!hasInitJni) {
            this.initJni();
        }
        this.init(fd);
        if (nullPath == null) {
            nullPath = new NullPath("jni-stream");
        }
        this.setPath(nullPath);
    }

    public JniStream() {
        if (!hasInitJni) {
            this.initJni();
        }
        if (nullPath == null) {
            nullPath = new NullPath("jni-stream");
        }
        this.setPath(nullPath);
    }

    public void init(int fd) {
        this.fd = fd;
    }

    void initJni() {
        hasInitJni = true;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.readNative(this.fd, buf, offset, length);
    }

    public int getAvailable() throws IOException {
        return -1;
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this.writeNative(this.fd, buf, offset, length);
        if (result < 0) {
            throw new ClientDisconnectException("connection reset by peer");
        }
    }

    public void flush() throws IOException {
        int result = this.flushNative(this.fd);
        if (result < 0) {
            throw new ClientDisconnectException("connection reset by peer");
        }
    }

    public void close() throws IOException {
    }
}

