/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.Connection;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.http.ChunkedInputStream;
import com.caucho.server.http.ContentLengthStream;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.port.ServerRequest;
import com.caucho.server.port.TcpConnection;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends AbstractHttpRequest
implements ServerRequest {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/http/HttpRequest"));
    static final int HTTP_0_9 = 9;
    static final int HTTP_1_0 = 256;
    static final int HTTP_1_1 = 257;
    static final CharBuffer _getCb = new CharBuffer("GET");
    static final CharBuffer _headCb = new CharBuffer("HEAD");
    static final CharBuffer _postCb = new CharBuffer("POST");
    static final char[] _hostCb = "Host".toCharArray();
    static final char[] _userAgentCb = "User-Agent".toCharArray();
    static final CharBuffer _http11Cb = new CharBuffer("HTTP/1.1");
    static final CharBuffer _http10Cb = new CharBuffer("HTTP/1.0");
    private String _scheme;
    private CharBuffer _method;
    private String _methodString;
    private CharBuffer _uriHost;
    private CharSequence _host;
    private CharBuffer _hostBuffer = new CharBuffer();
    private final byte[] _uri;
    private int _uriLength;
    private int _urlLengthMax = 8192;
    private CharBuffer _protocol;
    private int _version;
    private final InvocationKey _invocationKey = new InvocationKey();
    private final char[] _headerBuffer = new char[16384];
    private CharSegment[] _headerKeys;
    private CharSegment[] _headerValues;
    private int _headerCapacity = 256;
    private int _headerSize;
    private ChunkedInputStream _chunkedInputStream = new ChunkedInputStream();
    private ContentLengthStream _contentLengthStream = new ContentLengthStream();
    private ErrorPageManager _errorManager = new ErrorPageManager();
    private boolean _initAttributes;

    HttpRequest(DispatchServer server, Connection conn) {
        super(server, conn);
        this._response = new HttpResponse(this);
        this._response.init(conn.getWriteStream());
        this._uri = new byte[this._urlLengthMax];
        this._method = new CharBuffer();
        this._uriHost = new CharBuffer();
        this._protocol = new CharBuffer();
        this._headerCapacity = 256;
        this._headerSize = 0;
        this._headerKeys = new CharSegment[this._headerCapacity];
        this._headerValues = new CharSegment[this._headerCapacity];
        for (int i = 0; i < this._headerCapacity; ++i) {
            this._headerKeys[i] = new CharSegment();
            this._headerValues[i] = new CharSegment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleRequest() throws IOException {
        block31: {
            hasRequest = false;
            try {
                this.start();
                this._response.start();
                try {
                    if (!this.readRequest(this._rawRead)) {
                        if (HttpRequest.log.isLoggable(Level.FINE)) {
                            HttpRequest.log.fine(new StringBuffer().append(this.dbgId()).append("read timeout").toString());
                        }
                        var2_2 = false;
                        return var2_2;
                    }
                    hasRequest = true;
                    if (this._protocol.length() == 0) {
                        this._protocol.append("HTTP/0.9");
                    }
                    if (HttpRequest.log.isLoggable(Level.FINE)) {
                        HttpRequest.log.fine(new StringBuffer().append(this.dbgId()).append((Object)this._method).append(" ").append(new String(this._uri, 0, this._uriLength)).append(" ").append((Object)this._protocol).toString());
                    }
                    this.parseHeaders(this._rawRead);
                    if (this.getVersion() < 257 || !this.isForce10()) ** GOTO lbl30
                    this._protocol.clear();
                    this._protocol.append("HTTP/1.0");
                    this._version = 256;
                }
                catch (ClientDisconnectException e) {
                    throw e;
                }
                catch (Throwable e) {
                    HttpRequest.log.log(Level.FINER, e.toString(), e);
                    throw new BadRequestException(String.valueOf(e));
                }
lbl30:
                // 2 sources

                host = this.getHost();
                if (host == null && this.getVersion() >= 257) {
                    throw new BadRequestException("HTTP/1.1 requires host");
                }
                ipHost = this._conn.getVirtualHost();
                if (ipHost != null) {
                    host = ipHost;
                }
                this._invocationKey.init(host, this._conn.getLocalPort(), this._uri, this._uriLength);
                invocation = this._server.getInvocation(this._invocationKey);
                if (invocation == null) {
                    if (this._server.isModified()) {
                        HttpRequest.log.info("<server> is modified");
                        this.restartServer();
                        var5_13 = false;
                        return var5_13;
                    }
                    invocation = this._server.createInvocation();
                    if (host != null) {
                        hostName = host.toString().toLowerCase();
                        invocation.setHost(hostName);
                        invocation.setPort(this._conn.getLocalPort());
                        p = hostName.indexOf(58);
                        if (p > 0) {
                            invocation.setHostName(hostName.substring(0, p));
                        } else {
                            invocation.setHostName(hostName);
                        }
                    }
                    decoder = this._server.getInvocationDecoder();
                    decoder.splitQueryAndUnescape(invocation, this._uri, this._uriLength);
                    this._server.buildInvocation(this._invocationKey.clone(), invocation);
                }
                this.setInvocation(invocation);
                invocation.service((ServletRequest)this, (ServletResponse)this._response);
                break block31;
                finally {
                    this.finish();
                }
            }
            catch (ClientDisconnectException e) {
                this._response.killCache();
                throw e;
            }
            catch (Throwable e) {
                HttpRequest.log.log(Level.FINE, e.toString(), e);
                this.killKeepalive();
                try {
                    this._errorManager.sendServletError(e, (ServletRequest)this, (ServletResponse)this._response);
                }
                catch (ClientDisconnectException e1) {
                    throw e1;
                }
                catch (Exception e1) {
                    HttpRequest.log.log(Level.FINE, e1.toString(), e1);
                }
                var3_11 = false;
                return var3_11;
            }
            finally {
                if (hasRequest) {
                    this._response.finish();
                }
            }
        }
        if (HttpRequest.log.isLoggable(Level.FINE) == false) return this.allowKeepalive();
        HttpRequest.log.fine(new StringBuffer().append(this.dbgId()).append(this.allowKeepalive() != false ? "keepalive" : "no-keepalive").toString());
        return this.allowKeepalive();
    }

    private boolean isForce10() {
        if (this.getVersion() < 257) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    @Override
    protected void start() throws IOException {
        super.start();
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._uriLength = 0;
        this._uriHost.clear();
        this._host = null;
        this._headerSize = 0;
        this._initAttributes = false;
    }

    @Override
    public boolean isSecure() {
        return this._conn.isSecure() || this._conn.getLocalPort() == 443;
    }

    private boolean readRequest(ReadStream s) throws IOException {
        int readLength;
        boolean i = false;
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        if (readOffset >= (readLength = s.getLength())) {
            try {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
            }
            catch (InterruptedIOException e) {
                log.fine(new StringBuffer().append(this.dbgId()).append("keepalive timeout").toString());
                return false;
            }
            readOffset = 0;
        }
        byte ch = readBuffer[readOffset++];
        while (ch == 32 || ch == 9 || ch == 13 || ch == 10) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        char[] buffer = this._method.getBuffer();
        int length = buffer.length;
        int offset = 0;
        while (true) {
            if (length > offset) {
                if (ch >= 97 && ch <= 122) {
                    buffer[offset++] = (char)(ch + 65 - 97);
                } else {
                    if (ch <= 32) break;
                    buffer[offset++] = (char)ch;
                }
            }
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        this._method.setLength(offset);
        while (ch == 32 || ch == 9) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        byte[] uriBuffer = this._uri;
        int uriLength = 0;
        if (ch != 47) {
            byte ch1;
            while (ch > 32 && ch != 47) {
                if (readOffset >= readLength) {
                    readLength = s.fillBuffer();
                    if (readLength < 0) {
                        return false;
                    }
                    readOffset = 0;
                }
                ch = readBuffer[readOffset++];
            }
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    if (ch == 47) {
                        uriBuffer[uriLength++] = ch;
                        this._uriLength = uriLength;
                    }
                    return true;
                }
                readOffset = 0;
            }
            if ((ch1 = readBuffer[readOffset++]) != 47) {
                uriBuffer[uriLength++] = ch;
                ch = ch1;
            } else {
                block14: while (true) {
                    if (readOffset >= readLength) {
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            return true;
                        }
                        readOffset = 0;
                    }
                    ch = readBuffer[readOffset++];
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block14;
                        }
                        case 63: {
                            break block14;
                        }
                        case 47: {
                            break block14;
                        }
                        default: {
                            this._uriHost.append((char)ch);
                            continue block14;
                        }
                    }
                    break;
                }
            }
        }
        block15: while (true) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break block15;
                }
                default: {
                    uriBuffer[uriLength++] = ch;
                    if (readOffset >= readLength) {
                        readOffset = 0;
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            this._uriLength = uriLength;
                            return true;
                        }
                    }
                    ch = readBuffer[readOffset++];
                    continue block15;
                }
            }
            break;
        }
        this._uriLength = uriLength;
        while (ch == 32 || ch == 9) {
            if (readOffset >= readLength) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
            }
            ch = readBuffer[readOffset++];
        }
        buffer = this._protocol.getBuffer();
        length = buffer.length;
        offset = 0;
        while (ch != 32 && ch != 9 && ch != 13 && ch != 10) {
            if (offset < length) {
                buffer[offset++] = ch >= 97 && ch <= 122 ? (char)(ch + 65 - 97) : (char)ch;
            }
            if (readOffset >= readLength) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    this._protocol.setLength(offset);
                    return true;
                }
            }
            ch = readBuffer[readOffset++];
        }
        this._protocol.setLength(offset);
        if (offset == 0) {
            this._protocol.append("HTTP/0.9");
            this._version = 9;
        } else if (buffer[offset - 1] == '1' && this._protocol.equals(_http11Cb)) {
            this._version = 257;
        } else if (buffer[offset - 1] == '0' && this._protocol.equals(_http10Cb)) {
            this._version = 256;
        }
        while (ch != 10) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        s.setOffset(readOffset);
        return true;
    }

    private void parseHeaders(ReadStream s) throws IOException {
        int version = this.getVersion();
        if (version < 256) {
            return;
        }
        if (version < 257) {
            this.killKeepalive();
        }
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        int readLength = s.getLength();
        char[] headerBuffer = this._headerBuffer;
        int headerOffset = 1;
        int headerBufferSize = headerBuffer.length;
        headerBuffer[0] = 122;
        int headerSize = 0;
        this._headerSize = 0;
        CharSegment[] headerKeys = this._headerKeys;
        CharSegment[] headerValues = this._headerValues;
        boolean debug = log.isLoggable(Level.FINE);
        while (true) {
            int ch;
            int keyOffset = headerOffset;
            while (true) {
                if (readLength <= readOffset) {
                    readOffset = 0;
                    readLength = s.fillBuffer();
                    if (readLength <= 0) {
                        return;
                    }
                }
                if ((ch = readBuffer[readOffset++]) == 10) {
                    s.setOffset(readOffset);
                    return;
                }
                if (ch == 58) break;
                headerBuffer[headerOffset++] = (char)ch;
            }
            while (headerBuffer[headerOffset - 1] == ' ') {
                --headerOffset;
            }
            int keyLength = headerOffset - keyOffset;
            headerKeys[headerSize].init(headerBuffer, keyOffset, keyLength);
            do {
                if (readLength > readOffset) continue;
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength > 0) continue;
                return;
            } while ((ch = readBuffer[readOffset++]) == 32 || ch == 9);
            int valueOffset = headerOffset;
            while (true) {
                if (readLength <= readOffset) {
                    readOffset = 0;
                    readLength = s.fillBuffer();
                    if (readLength <= 0) break;
                }
                if (ch == 10) {
                    byte ch1 = readBuffer[readOffset];
                    if (ch1 != 32 && ch1 != 9) break;
                    ch = 32;
                    ++readOffset;
                    if (headerBuffer[headerOffset - 1] == '\r') {
                        // empty if block
                    }
                }
                int n = --headerOffset;
                ++headerOffset;
                headerBuffer[n] = (char)ch;
                ch = readBuffer[readOffset++];
            }
            while (headerBuffer[headerOffset - 1] <= ' ') {
                --headerOffset;
            }
            int valueLength = headerOffset - valueOffset;
            headerValues[headerSize].init(headerBuffer, valueOffset, valueLength);
            this.addHeaderInt(headerBuffer, keyOffset, keyLength, headerValues[headerSize]);
            if (debug) {
                log.fine(new StringBuffer().append(this.dbgId()).append((Object)headerKeys[headerSize]).append(": ").append((Object)headerValues[headerSize]).toString());
            }
            this._headerSize = ++headerSize;
        }
    }

    int getVersion() {
        char ch;
        if (this._version > 0) {
            return this._version;
        }
        CharSegment protocol = this.getProtocolBuffer();
        if (protocol.length() < 8) {
            this._version = 9;
            return this._version;
        }
        if (protocol.equals("HTTP/1.0")) {
            this._version = 256;
            return this._version;
        }
        if (protocol.equals("HTTP/1.1")) {
            this._version = 257;
            return 257;
        }
        if (protocol.equals("HTTP/0.9")) {
            this._version = 9;
            return 9;
        }
        int i = protocol.indexOf('/');
        int len = protocol.length();
        int major = 0;
        ++i;
        while (i < len) {
            char ch2 = protocol.charAt(i);
            if (ch2 < '0' || ch2 > '9') {
                if (ch2 == '.') break;
                this._version = 256;
                return this._version;
            }
            major = 10 * major + ch2 - 48;
            ++i;
        }
        int minor = 0;
        ++i;
        while (i < len && (ch = protocol.charAt(i)) >= '0' && ch <= '9') {
            minor = 10 * minor + ch - 48;
            ++i;
        }
        this._version = 256 * major + minor;
        return this._version;
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this._methodString = cb.equals(_getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this._methodString = cb.equals(_headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this._methodString = cb.equals(_postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this._methodString = cb.toString();
                }
            }
        }
        return this._methodString;
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    @Override
    protected CharSequence getHost() {
        if (this._host != null) {
            return this._host;
        }
        String virtualHost = this._conn.getVirtualHost();
        this._host = virtualHost != null ? virtualHost : (this._uriHost.length() > 0 ? this._uriHost : this._hostHeader);
        return this._host;
    }

    @Override
    public byte[] getUriBuffer() {
        return this._uri;
    }

    @Override
    public int getUriLength() {
        return this._uriLength;
    }

    @Override
    public String getProtocol() {
        switch (this._version) {
            case 257: {
                return "HTTP/1.1";
            }
            case 256: {
                return "HTTP/1.0";
            }
        }
        return "HTTP/0.9";
    }

    public CharSegment getProtocolBuffer() {
        return this._protocol;
    }

    @Override
    public void setHeader(String key, String value) {
        int i;
        int tail = this._headerSize > 0 ? this._headerValues[this._headerSize - 1].getOffset() + this._headerValues[this._headerSize - 1].getLength() : 0;
        char[] headerBuffer = this._headerBuffer;
        for (i = key.length() - 1; i >= 0; --i) {
            headerBuffer[tail + i] = key.charAt(i);
        }
        this._headerKeys[this._headerSize].init(headerBuffer, tail, key.length());
        tail += key.length();
        for (i = value.length() - 1; i >= 0; --i) {
            headerBuffer[tail + i] = value.charAt(i);
        }
        this._headerValues[this._headerSize].init(headerBuffer, tail, value.length());
        ++this._headerSize;
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] testBuf, int length) {
        char[] keyBuf = this._headerBuffer;
        CharSegment[] headerKeys = this._headerKeys;
        for (int i = this._headerSize - 1; i >= 0; --i) {
            int j;
            CharSegment key = headerKeys[i];
            if (key.length() != length) continue;
            int offset = key.getOffset();
            for (j = length - 1; j >= 0; --j) {
                char a = testBuf[j];
                char b = keyBuf[offset + j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j >= 0) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        int i = this.matchNextHeader(0, key);
        if (i >= 0) {
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i]);
        }
    }

    @Override
    public Enumeration getHeaders(String key) {
        ArrayList<String> values = new ArrayList<String>();
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i].toString());
        }
        return Collections.enumeration(values);
    }

    private int matchNextHeader(int i, String key) {
        int size = this._headerSize;
        int length = key.length();
        char[] keyBuf = this._headerBuffer;
        while (i < size) {
            CharSegment header = this._headerKeys[i];
            if (header.length() == length) {
                int j;
                int offset = header.getOffset();
                for (j = 0; j < length; ++j) {
                    char b;
                    char a = key.charAt(j);
                    if (a == (b = keyBuf[offset + j])) continue;
                    if (a >= 'A' && a <= 'Z') {
                        a = (char)(a + 32);
                    }
                    if (b >= 'A' && b <= 'Z') {
                        b = (char)(b + 32);
                    }
                    if (a != b) break;
                }
                if (j == length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Enumeration getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            String oldName;
            int j;
            CharSegment name = this._headerKeys[i];
            for (j = 0; j < names.size() && !name.matches(oldName = (String)names.get(j)); ++j) {
            }
            if (j != names.size()) continue;
            names.add(j, name.toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public boolean initStream(ReadStream readStream, ReadStream rawRead) throws IOException {
        String te;
        int contentLength = this.getContentLength();
        if (contentLength < 0 && 257 <= this.getVersion() && (te = this.getHeader("Transfer-Encoding")) != null) {
            this._chunkedInputStream.init(rawRead);
            readStream.init(this._chunkedInputStream, null);
            return true;
        }
        if (contentLength >= 0) {
            this._contentLengthStream.init(rawRead, contentLength);
            this._readStream.init(this._contentLengthStream, null);
            return true;
        }
        if (this.getMethod().equals("POST")) {
            this._contentLengthStream.init(rawRead, 0);
            this._readStream.init(this._contentLengthStream, null);
            throw new BadRequestException("POST requires content-length");
        }
        this._contentLengthStream.init(rawRead, 0);
        this._readStream.init(this._contentLengthStream, null);
        return false;
    }

    @Override
    protected void skip() throws IOException {
        if (this.getMethod() == "GET") {
            return;
        }
        super.skip();
    }

    @Override
    public Object getAttribute(String name) {
        if (!this._initAttributes) {
            this.initAttributes();
        }
        return super.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (!this._initAttributes) {
            this.initAttributes();
        }
        return super.getAttributeNames();
    }

    @Override
    public String findSessionIdFromConnection() {
        Connection conn = this.getConnection();
        if (!this.isSecure() || !(conn instanceof TcpConnection)) {
            return null;
        }
        TcpConnection tcpConn = (TcpConnection)conn;
        QSocket socket = tcpConn.getSocket();
        return null;
    }

    @Override
    public ReadStream getRawInput() {
        return this._rawRead;
    }

    private void initAttributes() {
        this._initAttributes = true;
        Connection conn = this.getConnection();
        if (!this.isSecure() || !(conn instanceof TcpConnection)) {
            return;
        }
        TcpConnection tcpConn = (TcpConnection)conn;
        QSocket socket = tcpConn.getSocket();
        String cipherSuite = socket.getCipherSuite();
        super.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
        int keySize = socket.getCipherBits();
        if (keySize != 0) {
            super.setAttribute("javax.servlet.request.key_size", new Integer(keySize));
        }
        try {
            X509Certificate[] certs = socket.getClientCertificates();
            if (certs != null && certs.length > 0) {
                super.setAttribute("javax.servlet.request.X509Certificate", certs);
                super.setAttribute("com.caucho.servlet.login.name", certs[0].getSubjectDN());
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    @Override
    public void finish() throws IOException {
        super.finish();
        this.skip();
    }

    String dbgId() {
        if ("".equals(this._server.getServerId())) {
            return new StringBuffer().append("[").append(this._conn.getId()).append("] ").toString();
        }
        return new StringBuffer().append("[").append(this._server.getServerId()).append(", ").append(this._conn.getId()).append("] ").toString();
    }
}

