/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

class ChunkedInputStream
extends StreamImpl {
    private ReadStream _next;
    private int _available;

    ChunkedInputStream() {
    }

    void init(ReadStream next) {
        this._next = next;
        this._available = 0;
    }

    public boolean canRead() {
        return true;
    }

    public int getAvailable() {
        return this._available;
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this._available > 0) {
            if (this._available < len) {
                len = this._available;
            }
            if ((len = this._next.read(buf, offset, len)) > 0) {
                this._available -= len;
            }
        } else if (this._available == 0) {
            this._available = this.readChunkLength();
            if (this._available > 0) {
                if (this._available < len) {
                    len = this._available;
                }
                if ((len = this._next.read(buf, offset, len)) > 0) {
                    this._available -= len;
                }
            } else {
                this._available = -1;
                len = -1;
            }
        } else {
            len = -1;
        }
        return len;
    }

    private int readChunkLength() throws IOException {
        int length = 0;
        int ch = this._next.read();
        while (ch == 13 || ch == 32 || ch == 10) {
            ch = this._next.read();
        }
        while (ch > 0 && ch != 13 && ch != 10) {
            if (ch >= 48 && ch <= 57) {
                length = 16 * length + ch - 48;
            } else if (ch >= 97 && ch <= 102) {
                length = 16 * length + ch - 97 + 10;
            } else if (ch >= 65 && ch <= 70) {
                length = 16 * length + ch - 65 + 10;
            } else if (ch != 32 && ch != 9) {
                throw new IOException("HTTP/1.1 protocol error: bad chunk");
            }
            ch = this._next.read();
        }
        if (ch == 13) {
            ch = this._next.read();
        }
        return length;
    }
}

