/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.BuilderProgram;
import com.caucho.config.RegistryBuilder;
import com.caucho.config.TypeBuilderFactory;
import com.caucho.config.types.PathBuilder;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.ExpandEntry;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.mbean.HostMBean;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HostEntry
extends ExpandEntry<Host> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/host/HostEntry"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/host/HostEntry"));
    private HostContainer _container;
    private String _hostName;
    private String _regexpName;
    private ArrayList<String> _entryHostAliases = new ArrayList();
    private ArrayList<String> _hostAliases = new ArrayList();
    private HostConfig _config;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private boolean _isInit;
    private BuilderProgram _initProgram;
    private ObjectName _mbeanName;
    private Object _mbean;
    private VariableResolver _variableResolver;
    private HashMap<String, Object> _variableMap = new HashMap();
    private Var _hostVar = new Var();
    private Path _cfgRootDir;
    private Path _jarRootDir;
    private ArrayList<Dependency> _dependList = new ArrayList();
    private long _startTime;

    HostEntry(HostContainer container, HostConfig config) {
        this._container = container;
        this._config = config;
        if (config != null) {
            this.setStartupMode(config.getStartupMode());
        }
        VariableResolver parentResolver = TypeBuilderFactory.getEnvironment();
        this._variableResolver = new MapVariableResolver(this._variableMap, parentResolver);
        this._variableMap.put("host", this._hostVar);
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        return this.getHostName();
    }

    @Override
    public void setName(String name) {
        name = name.toLowerCase();
        this._variableMap.put("name", name);
        super.setName(name);
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setHostName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.equals("*")) {
            name = "";
        }
        this._hostName = name = name.toLowerCase();
    }

    public void setRegexpName(String name) {
        this._regexpName = name.toLowerCase();
    }

    public void addHostAlias(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.equals("*")) {
            name = "";
        }
        if (!this._entryHostAliases.contains(name = name.toLowerCase())) {
            this._entryHostAliases.add(name);
        }
        this.addExtHostAlias(name);
    }

    public void addExtHostAlias(String name) {
        if (!this._hostAliases.contains(name)) {
            this._hostAliases.add(name);
        }
    }

    public ArrayList<String> getHostAliases() {
        return this._hostAliases;
    }

    public HostConfig getHostConfig() {
        return this._config;
    }

    public HashMap<String, Object> getVariableMap() {
        return this._variableMap;
    }

    public void addVariableMap(HashMap<String, Object> map) {
        this._variableMap.putAll(map);
    }

    public VariableResolver getVariableResolver() {
        return this._variableResolver;
    }

    public BuilderProgram getInitProgram() {
        return this._initProgram;
    }

    public void setInitProgram(BuilderProgram initProgram) {
        this._initProgram = initProgram;
    }

    public Object getMBean() {
        return this._mbean;
    }

    public void addHostDefault(HostConfig config) {
        this._hostDefaults.add(config);
    }

    public Path getCfgRootDirectory() {
        return this._cfgRootDir;
    }

    public void setCfgRootDirectory(Path rootDir) {
        this._cfgRootDir = rootDir;
    }

    public Path getJarRootDir() {
        return this._jarRootDir;
    }

    public void setJarRootDir(Path rootDir) {
        this._jarRootDir = rootDir;
    }

    public void addDepend(Path depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(new Depend(depend));
        }
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        try {
            try {
                if (this._config != null && this.getHostName() == null && this._config.getHostName() != null) {
                    this.setHostName(EL.evalString(this._config.getHostName(), this._variableResolver));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            if (this._regexpName != null && this._hostName == null) {
                this._hostName = this._regexpName;
            }
            if (this._hostName == null) {
                this._hostName = "";
            }
            if (super.getName() == null) {
                this.setName(this.getHostName());
            }
            ArrayList<String> aliases = null;
            if (this._config != null) {
                aliases = this._config.getHostAliases();
            }
            for (int i = 0; aliases != null && i < aliases.size(); ++i) {
                String alias = aliases.get(i);
                alias = EL.evalString(alias, this._variableResolver);
                this.addHostAlias(alias);
            }
            this.setRootDirectory(this.calculateRootDirectory());
            LinkedHashMap<String, String> properties = Jmx.copyContextProperties();
            properties.put("type", "Host");
            String name = this._hostName;
            if (name == null) {
                name = "";
            }
            if (name.equals("")) {
                properties.put("name", "default");
            } else {
                properties.put("name", name);
            }
            this._mbeanName = Jmx.getObjectName("resin", properties);
            this._mbean = new IntrospectionMBean(new Admin(), ClassLiteral.getClass((String)"com/caucho/server/host/mbean/HostMBean"));
            Jmx.register(this._mbean, this._mbeanName);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return true;
    }

    protected void deployHost() throws Exception {
    }

    @Override
    public boolean isNameMatch(String name) {
        if (this._hostName.equalsIgnoreCase(name)) {
            return true;
        }
        for (int i = this._hostAliases.size() - 1; i >= 0; --i) {
            if (!name.equalsIgnoreCase(this._hostAliases.get(i))) continue;
            return true;
        }
        return false;
    }

    protected HostEntry merge(HostEntry newEntry) {
        if (this._config.getRegexp() != null) {
            return newEntry;
        }
        if (newEntry._config.getRegexp() != null) {
            return this;
        }
        return newEntry;
    }

    @Override
    protected Host instantiateDeployInstance() {
        return new Host(this._container, this, this._hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInstance(Host host) throws Throwable {
        this._hostAliases.clear();
        this._hostAliases.addAll(this._entryHostAliases);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        Path rootDir = null;
        try {
            int i;
            if (this._container != null) {
                thread.setContextClassLoader(this._container.getClassLoader());
            }
            HashMap<String, Object> varMap = host.getVariableMap();
            varMap.putAll(this._variableMap);
            rootDir = this.calculateRootDirectory();
            if (rootDir == null) {
                throw new NullPointerException("Null root-directory");
            }
            host.setRootDirectory(rootDir);
            varMap.put("host-root", rootDir);
            ArrayList<HostConfig> initList = new ArrayList<HostConfig>();
            if (this._container != null) {
                initList.addAll(this._container.getHostDefaultList());
                ArrayList<WebAppConfig> appDefaults = this._container.getWebAppDefaultList();
                for (int i2 = 0; i2 < appDefaults.size(); ++i2) {
                    WebAppConfig init = appDefaults.get(i2);
                    host.addWebAppDefault(init);
                }
            }
            MergePath schemaPath = new MergePath();
            schemaPath.addClassPath();
            RegistryBuilder builder = new RegistryBuilder();
            initList.addAll(this._hostDefaults);
            if (this._config != null) {
                initList.add(this._config);
            }
            thread.setContextClassLoader(host.getClassLoader());
            Vfs.setPwd(rootDir);
            for (i = 0; i < this._dependList.size(); ++i) {
                Dependency depend = this._dependList.get(i);
                Environment.addDependency(depend);
            }
            for (i = 0; i < initList.size(); ++i) {
                HostConfig config = (HostConfig)initList.get(i);
                BuilderProgram program = config.getBuilderProgram();
                if (program == null) continue;
                program.configure(host);
            }
            host.init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path calculateRootDirectory() throws ELException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            String path;
            thread.setContextClassLoader(this._container.getClassLoader());
            Path rootDir = this.getRootDirectory();
            if (rootDir == null && this._config != null && (path = this._config.getRootDirectory()) != null) {
                rootDir = PathBuilder.lookupPath(path, this._variableResolver);
            }
            if (rootDir == null) {
                rootDir = this._cfgRootDir;
            }
            Host host = (Host)this.getDeployInstance();
            if (rootDir == null && host != null) {
                rootDir = host.getRootDirectory();
            }
            if (rootDir == null) {
                rootDir = Vfs.lookup();
            }
            Path path2 = rootDir;
            return path2;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HostEntry)) {
            return false;
        }
        HostEntry entry = (HostEntry)o;
        return this._hostName.equals(entry._hostName);
    }

    @Override
    public String toString() {
        return new StringBuffer().append("HostEntry[").append(this.getName()).append("]").toString();
    }

    public class Admin
    implements HostMBean {
        public String getName() {
            return HostEntry.this.getName();
        }

        public String getHostName() {
            return HostEntry.this.getHostName();
        }

        public String getURL() {
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                return host.getURL();
            }
            return null;
        }

        public Date getStartTime() {
            return new Date(HostEntry.this.getStartTime());
        }

        public String getRootDirectory() {
            Host host = (Host)HostEntry.this.getDeployInstance();
            Path path = host != null ? host.getRootDirectory() : HostEntry.this.getRootDirectory();
            if (path != null) {
                return path.getNativePath();
            }
            return null;
        }

        public String getDocumentDirectory() {
            Path path = null;
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                path = host.getDocumentDirectory();
            }
            if (path != null) {
                return path.getNativePath();
            }
            return null;
        }

        public String getWarDirectory() {
            Path path = null;
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                path = host.getWarDir();
            }
            if (path != null) {
                return path.getNativePath();
            }
            return null;
        }

        public String getWarExpandDirectory() {
            Path path = null;
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                path = host.getWarExpandDir();
            }
            if (path != null) {
                return path.getNativePath();
            }
            return null;
        }

        public void updateWebAppDeploy(String name) {
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                host.updateWebAppDeploy(name);
            }
        }

        public void updateEarDeploy(String name) {
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                host.updateEarDeploy(name);
            }
        }

        public String toString() {
            return "MBean[" + HostEntry.this.toString() + "]";
        }
    }

    public class Var {
        public String getName() {
            return HostEntry.this.getName();
        }

        public String getHostName() {
            return HostEntry.this.getHostName();
        }

        public String getURL() {
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                return host.getURL();
            }
            if (HostEntry.this._hostName.equals("")) {
                return "";
            }
            if (HostEntry.this._hostName.startsWith("http:") || HostEntry.this._hostName.startsWith("https:")) {
                return HostEntry.this._hostName;
            }
            return "http://" + HostEntry.this._hostName;
        }

        public ArrayList getRegexp() {
            return (ArrayList)HostEntry.this._variableMap.get("regexp");
        }

        public Path getRootDirectory() {
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                return host.getRootDirectory();
            }
            return HostEntry.this.getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRootDirectory();
        }

        public Path getDocumentDirectory() {
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                return host.getDocumentDirectory();
            }
            return null;
        }

        public Path getDocDir() {
            return this.getDocumentDirectory();
        }

        public Path getWarDirectory() {
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                return host.getWarDir();
            }
            return null;
        }

        public Path getWarDir() {
            return this.getWarDirectory();
        }

        public Path getWarExpandDirectory() {
            Host host = (Host)HostEntry.this.getDeployInstance();
            if (host != null) {
                return host.getWarExpandDir();
            }
            return null;
        }

        public Path getWarExpandDir() {
            return this.getWarExpandDirectory();
        }

        public String toString() {
            return "Host[" + this.getName() + "]";
        }
    }
}

