/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.log.Log;
import com.caucho.server.deploy.Entry;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostConfig {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/host/HostConfig"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/host/HostConfig"));
    private String _hostName;
    private ArrayList<String> _hostAliases = new ArrayList();
    private Pattern _regexp;
    private String _rootDir;
    private String _startupMode = "automatic";
    private BuilderProgramContainer _program = new BuilderProgramContainer();

    public void setHostName(RawString name) throws ConfigException {
        this._hostName = name.getValue();
        if (this._hostName.indexOf("${") < 0) {
            for (int i = 0; i < this._hostName.length(); ++i) {
                char ch = this._hostName.charAt(i);
                if (ch != ' ' && ch != '\t' && ch != ',') continue;
                throw new ConfigException(L.l("Host name `{0}' must not contain multiple names.  Use <host-alias> to specify aliases for a host.", this._hostName));
            }
        }
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setId(RawString id) throws ConfigException {
        this.setHostName(id);
    }

    public void addHostAlias(RawString rawName) throws ConfigException {
        String name = rawName.getValue().trim();
        if (name.indexOf("${") < 0) {
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (ch != ' ' && ch != '\t' && ch != ',') continue;
                throw new ConfigException(L.l("<host-alias> `{0}' must not contain multiple names.  Use multiple <host-alias> tags to specify aliases for a host.", name));
            }
        }
        if (!this._hostAliases.contains(name)) {
            this._hostAliases.add(name);
        }
    }

    public ArrayList<String> getHostAliases() {
        return this._hostAliases;
    }

    public void setRegexp(RawString regexp) {
        String value = regexp.getValue();
        if (!value.endsWith("$")) {
            value = new StringBuffer().append(value).append("$").toString();
        }
        this._regexp = Pattern.compile(value, 2);
    }

    public Pattern getRegexp() {
        return this._regexp;
    }

    public void setRootDirectory(RawString rootDir) {
        this._rootDir = rootDir.getValue();
    }

    public void setRootDir(RawString rootDir) {
        this.setRootDirectory(rootDir);
    }

    public String getRootDirectory() {
        return this._rootDir;
    }

    public void setLazyInit(boolean lazyInit) {
        this._startupMode = lazyInit ? "lazy" : "automatic";
    }

    public void setStartupMode(String mode) throws ConfigException {
        this._startupMode = Entry.toStartupCode(mode);
    }

    public String getStartupMode() {
        return this._startupMode;
    }

    public void addBuilderProgram(BuilderProgram program) {
        this._program.addProgram(program);
    }

    public BuilderProgram getBuilderProgram() {
        return this._program;
    }

    public void init() {
        if (this._regexp != null && this._hostName == null) {
            log.config(L.l("<host regexp=\"{0}\"> should include a <host-name> tag.", this._regexp.pattern()));
        }
    }
}

