/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.log.Log;
import com.caucho.security.BasicPrincipal;
import com.caucho.server.cluster.BackingManager;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.Connection;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.hmux.AbstractClusterRequest;
import com.caucho.server.hmux.HmuxDispatchRequest;
import com.caucho.server.hmux.HmuxResponse;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.port.ServerRequest;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmuxRequest
extends AbstractHttpRequest
implements ServerRequest {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/hmux/HmuxRequest"));
    public static final int HMUX_CHANNEL = 67;
    public static final int HMUX_ACK = 65;
    public static final int HMUX_ERROR = 69;
    public static final int HMUX_YIELD = 89;
    public static final int HMUX_QUIT = 81;
    public static final int HMUX_EXIT = 88;
    public static final int HMUX_DATA = 68;
    public static final int HMUX_URI = 85;
    public static final int HMUX_STRING = 83;
    public static final int HMUX_HEADER = 72;
    public static final int HMUX_PROTOCOL = 80;
    public static final int CSE_NULL = 63;
    public static final int CSE_PATH_INFO = 98;
    public static final int CSE_PROTOCOL = 99;
    public static final int CSE_REMOTE_USER = 100;
    public static final int CSE_QUERY_STRING = 101;
    public static final int HMUX_FLUSH = 102;
    public static final int CSE_SERVER_PORT = 103;
    public static final int CSE_REMOTE_HOST = 104;
    public static final int CSE_REMOTE_ADDR = 105;
    public static final int CSE_REMOTE_PORT = 106;
    public static final int CSE_REAL_PATH = 107;
    public static final int CSE_SCRIPT_FILENAME = 108;
    public static final int HMUX_METHOD = 109;
    public static final int CSE_AUTH_TYPE = 110;
    public static final int CSE_URI = 111;
    public static final int CSE_CONTENT_LENGTH = 112;
    public static final int CSE_CONTENT_TYPE = 113;
    public static final int CSE_IS_SECURE = 114;
    public static final int HMUX_STATUS = 115;
    public static final int CSE_CLIENT_CERT = 116;
    public static final int CSE_SERVER_TYPE = 117;
    public static final int HMUX_SERVER_NAME = 118;
    public static final int CSE_SEND_HEADER = 71;
    public static final int CSE_DATA = 68;
    public static final int CSE_FLUSH = 70;
    public static final int CSE_KEEPALIVE = 75;
    public static final int CSE_ACK = 65;
    public static final int CSE_END = 90;
    public static final int CSE_CLOSE = 88;
    public static final int CSE_QUERY = 81;
    public static final int CSE_PING = 80;
    public static final int HMUX_CLUSTER_PROTOCOL = 257;
    public static final int HMUX_DISPATCH_PROTOCOL = 258;
    static final int HTTP_0_9 = 9;
    static final int HTTP_1_0 = 256;
    static final int HTTP_1_1 = 257;
    static final CharBuffer _getCb = new CharBuffer("GET");
    static final CharBuffer _headCb = new CharBuffer("HEAD");
    static final CharBuffer _postCb = new CharBuffer("POST");
    private final CharBuffer _method;
    private String _methodString;
    private CharBuffer _host;
    private int _port;
    private ByteBuffer _uri;
    private CharBuffer _protocol;
    private int _version;
    private CharBuffer _remoteAddr;
    private CharBuffer _remoteHost;
    private CharBuffer _serverName;
    private CharBuffer _serverPort;
    private CharBuffer _remotePort;
    private boolean _isSecure;
    private ByteBuffer _clientCert;
    private CharBuffer[] _headerKeys;
    private CharBuffer[] _headerValues;
    private int _headerSize;
    private byte[] _lengthBuf;
    private int _serverType;
    private WriteStream _rawWrite;
    private WriteStream _writeStream;
    private ServletFilter _filter;
    private int _pendingData;
    private InvocationKey _invocationKey = new InvocationKey();
    private CharBuffer _cb1;
    private CharBuffer _cb2;
    private boolean _hasRequest;
    private AbstractClusterRequest _clusterRequest;
    private HmuxDispatchRequest _dispatchRequest;
    private BackingManager _backingManager;
    private Cluster _cluster;
    private ErrorPageManager _errorManager = new ErrorPageManager();
    private int _srunIndex;

    public HmuxRequest(DispatchServer server, Connection conn) {
        super(server, conn);
        this._response = new HmuxResponse(this);
        this._rawWrite = conn.getWriteStream();
        this._writeStream = new WriteStream();
        this._writeStream.setReuseBuffer(true);
        this._cluster = Cluster.getLocal();
        if (this._cluster != null) {
            try {
                Class<?> cl = Class.forName("com.caucho.server.hmux.HmuxClusterRequest");
                this._clusterRequest = (AbstractClusterRequest)cl.newInstance();
                this._clusterRequest.setRequest(this);
                this._clusterRequest.setCluster(this._cluster);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        this._dispatchRequest = new HmuxDispatchRequest(this);
        this._uri = new ByteBuffer();
        this._method = new CharBuffer();
        this._host = new CharBuffer();
        this._protocol = new CharBuffer();
        this._headerKeys = new CharBuffer[64];
        this._headerValues = new CharBuffer[64];
        for (int i = 0; i < this._headerKeys.length; ++i) {
            this._headerKeys[i] = new CharBuffer();
            this._headerValues[i] = new CharBuffer();
        }
        this._remoteHost = new CharBuffer();
        this._remoteAddr = new CharBuffer();
        this._serverName = new CharBuffer();
        this._serverPort = new CharBuffer();
        this._remotePort = new CharBuffer();
        this._clientCert = new ByteBuffer();
        this._cb1 = new CharBuffer();
        this._cb2 = new CharBuffer();
        this._lengthBuf = new byte[16];
        this._filter = new ServletFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleRequest() throws IOException {
        block78: {
            boolean bl;
            boolean bl2;
            boolean hasRequest;
            block64: {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(new StringBuffer().append(this.dbgId()).append("start request").toString());
                }
                this._filter.init(this, this._rawRead, this._rawWrite);
                this._writeStream.init(this._filter);
                this._writeStream.setWritePrefix(3);
                this._response.init(this._writeStream);
                this._serverType = 0;
                hasRequest = false;
                this.start();
                this._response.start();
                if (this.scanHeaders()) break block63;
                this.killKeepalive();
                bl2 = false;
                Object var6_9 = null;
                if (hasRequest) break block64;
                this._response.setHeaderWritten(true);
            }
            try {
                this.finish();
                this._response.finish();
            }
            catch (ClientDisconnectException e2) {
                throw e2;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            try {
                this._writeStream.setDisableClose(false);
                this._writeStream.close();
            }
            catch (ClientDisconnectException e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            try {
                this._readStream.setDisableClose(false);
                this._readStream.close();
            }
            catch (ClientDisconnectException e3) {
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            {
                block63: {
                    return bl2;
                }
                if (this._uri.size() != 0) break block67;
                bl = true;
            }
            Object var6_10 = null;
            if (!hasRequest) {
                this._response.setHeaderWritten(true);
            }
            try {
                this.finish();
                this._response.finish();
            }
            catch (ClientDisconnectException e2) {
                throw e2;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            try {
                this._writeStream.setDisableClose(false);
                this._writeStream.close();
            }
            catch (ClientDisconnectException e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            try {
                this._readStream.setDisableClose(false);
                this._readStream.close();
            }
            catch (ClientDisconnectException e3) {
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            {
                block67: {
                    return bl;
                    catch (InterruptedIOException e) {
                        this.killKeepalive();
                        log.fine(new StringBuffer().append(this.dbgId()).append("interrupted keepalive").toString());
                        boolean bl3 = false;
                        Object var6_11 = null;
                        if (!hasRequest) {
                            this._response.setHeaderWritten(true);
                        }
                        try {
                            this.finish();
                            this._response.finish();
                        }
                        catch (ClientDisconnectException e2) {
                            throw e2;
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                        }
                        try {
                            this._writeStream.setDisableClose(false);
                            this._writeStream.close();
                        }
                        catch (ClientDisconnectException e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                            throw e3;
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                        }
                        try {
                            this._readStream.setDisableClose(false);
                            this._readStream.close();
                        }
                        catch (ClientDisconnectException e3) {
                            throw e3;
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                        }
                        return bl3;
                    }
                }
                if (this._isSecure) {
                    this.getClientCertificate();
                }
                hasRequest = true;
                this._filter.setPending(this._pendingData);
                try {
                    if (this._method.getLength() == 0) {
                        throw new RuntimeException("HTTP protocol exception");
                    }
                    this._invocationKey.init(this.getHost(), this.getServerPort(), this._uri.getBuffer(), this._uri.getLength());
                    Invocation invocation = this._server.getInvocation(this._invocationKey);
                    if (invocation == null) {
                        invocation = this._server.createInvocation();
                        if (this._host != null) {
                            invocation.setHost(this._host.toString());
                        }
                        invocation.setPort(this.getServerPort());
                        InvocationDecoder decoder = this._server.getInvocationDecoder();
                        decoder.splitQueryAndUnescape(invocation, this._uri.getBuffer(), this._uri.getLength());
                        this._server.buildInvocation(this._invocationKey.clone(), invocation);
                    }
                    this.setInvocation(invocation);
                    invocation.service((ServletRequest)this, (ServletResponse)this._response);
                }
                catch (ClientDisconnectException e) {
                    throw e;
                }
                catch (Throwable e) {
                    try {
                        this._errorManager.sendServletError(e, (ServletRequest)this, (ServletResponse)this._response);
                    }
                    catch (ClientDisconnectException e1) {
                        throw e1;
                    }
                    catch (Exception e1) {
                        log.log(Level.FINE, e1.toString(), e1);
                        boolean bl4 = false;
                        Object var6_12 = null;
                        if (!hasRequest) {
                            this._response.setHeaderWritten(true);
                        }
                        try {
                            this.finish();
                            this._response.finish();
                        }
                        catch (ClientDisconnectException e2) {
                            throw e2;
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                        }
                        try {
                            this._writeStream.setDisableClose(false);
                            this._writeStream.close();
                        }
                        catch (ClientDisconnectException e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                            throw e3;
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                        }
                        try {
                            this._readStream.setDisableClose(false);
                            this._readStream.close();
                        }
                        catch (ClientDisconnectException e3) {
                            throw e3;
                        }
                        catch (Exception e3) {
                            this.killKeepalive();
                            log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                        }
                        return bl4;
                    }
                }
            }
            Object var6_13 = null;
            if (!hasRequest) {
                this._response.setHeaderWritten(true);
            }
            try {
                this.finish();
                this._response.finish();
            }
            catch (ClientDisconnectException e2) {
                throw e2;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            try {
                this._writeStream.setDisableClose(false);
                this._writeStream.close();
            }
            catch (ClientDisconnectException e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            try {
                this._readStream.setDisableClose(false);
                this._readStream.close();
            }
            catch (ClientDisconnectException e3) {
                throw e3;
            }
            catch (Exception e3) {
                this.killKeepalive();
                log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
            }
            break block78;
            catch (Throwable throwable) {
                Object var6_14 = null;
                if (!hasRequest) {
                    this._response.setHeaderWritten(true);
                }
                try {
                    this.finish();
                    this._response.finish();
                }
                catch (ClientDisconnectException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    this.killKeepalive();
                    log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                }
                try {
                    this._writeStream.setDisableClose(false);
                    this._writeStream.close();
                }
                catch (ClientDisconnectException e3) {
                    this.killKeepalive();
                    log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                    throw e3;
                }
                catch (Exception e3) {
                    this.killKeepalive();
                    log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                }
                try {
                    this._readStream.setDisableClose(false);
                    this._readStream.close();
                }
                catch (ClientDisconnectException e3) {
                    throw e3;
                }
                catch (Exception e3) {
                    this.killKeepalive();
                    log.log(Level.FINE, new StringBuffer().append(this.dbgId()).append(e3).toString(), e3);
                }
                throw throwable;
            }
        }
        boolean allowKeepalive = this.allowKeepalive();
        if (log.isLoggable(Level.FINE)) {
            if (allowKeepalive) {
                log.fine(new StringBuffer().append(this.dbgId()).append("complete request - keepalive").toString());
            } else {
                log.fine(new StringBuffer().append(this.dbgId()).append("complete request").toString());
            }
        }
        return allowKeepalive;
    }

    @Override
    protected boolean initStream(ReadStream readStream, ReadStream rawStream) throws IOException {
        readStream.init(this._filter, null);
        return true;
    }

    private void getClientCertificate() {
        String keySize;
        String cipher = this.getHeader("SSL_CIPHER");
        if (cipher == null) {
            cipher = this.getHeader("HTTPS_CIPHER");
        }
        if (cipher != null) {
            this.setAttribute("javax.servlet.request.cipher_suite", cipher);
        }
        if ((keySize = this.getHeader("SSL_CIPHER_USEKEYSIZE")) == null) {
            keySize = this.getHeader("SSL_SECRETKEYSIZE");
        }
        if (keySize != null) {
            this.setAttribute("javax.servlet.request.key_size", keySize);
        }
        if (this._clientCert.size() == 0) {
            return;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream is = this._clientCert.createInputStream();
            Certificate cert = cf.generateCertificate(is);
            is.close();
            this.setAttribute("javax.servlet.request.X509Certificate", cert);
            this.setAttribute("com.caucho.servlet.login.name", ((X509Certificate)cert).getSubjectDN());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    @Override
    protected void start() throws IOException {
        super.start();
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._version = 0;
        this._uri.clear();
        this._host.clear();
        this._port = 0;
        this._headerSize = 0;
        this._remoteHost.clear();
        this._remoteAddr.clear();
        this._serverName.clear();
        this._serverPort.clear();
        this._remotePort.clear();
        this._clientCert.clear();
        this._pendingData = 0;
        this._isSecure = false;
    }

    private boolean scanHeaders() throws IOException {
        boolean hasURI = false;
        CharBuffer cb = this._cb;
        boolean isLoggable = log.isLoggable(Level.FINE);
        ReadStream is = this._rawRead;
        int code = is.read();
        if (code != 67) {
            if (isLoggable) {
                log.fine(new StringBuffer().append(this.dbgId()).append("closing ").append((char)code).append("(").append(code).append(")").toString());
            }
            return false;
        }
        int channel = (is.read() << 8) + is.read();
        block24: while (true) {
            code = is.read();
            switch (code) {
                case -1: {
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append("end of file").toString());
                    }
                    return false;
                }
                case 81: {
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(": end of request").toString());
                    }
                    return hasURI;
                }
                case 88: {
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(": end of socket").toString());
                    }
                    this.killKeepalive();
                    return hasURI;
                }
                case 80: {
                    int len = (is.read() << 8) + is.read();
                    if (len != 4) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(": protocol length (").append(len).append(") must be 4.").toString());
                        this.killKeepalive();
                        return false;
                    }
                    int value = (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
                    if (value == 257) {
                        if (isLoggable) {
                            log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(": cluster protocol").toString());
                        }
                        this._filter.setClientClosed(true);
                        return this._clusterRequest.handleRequest(is, this._rawWrite);
                    }
                    if (value == 258) {
                        if (isLoggable) {
                            log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(": dispatch protocol").toString());
                        }
                        this._filter.setClientClosed(true);
                        return this._dispatchRequest.handleRequest(is, this._rawWrite);
                    }
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(": unknown protocol (").append(value).append(")").toString());
                    return false;
                }
                case 85: {
                    hasURI = true;
                    int len = (is.read() << 8) + is.read();
                    this._uri.setLength(len);
                    this._rawRead.readAll(this._uri.getBuffer(), 0, len);
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(":uri ").append(this._uri).toString());
                    break;
                }
                case 109: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._method, len);
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(":method ").append((Object)this._method).toString());
                    break;
                }
                case 107: {
                    int len = (is.read() << 8) + is.read();
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    code = this._rawRead.read();
                    if (code != 83) {
                        throw new IOException("protocol expected HMUX_STRING");
                    }
                    this._cb2.clear();
                    this._rawRead.readAll(this._cb2, this.readLength());
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" ").append(this._cb1.toString()).append("->").append(this._cb2.toString()).toString());
                    break;
                }
                case 104: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._remoteHost, len);
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)this._remoteHost).toString());
                    break;
                }
                case 105: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._remoteAddr, len);
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)this._remoteAddr).toString());
                    break;
                }
                case 118: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._serverName, len);
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" server-host: ").append((Object)this._serverName).toString());
                    break;
                }
                case 106: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._remotePort, len);
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" remote-port: ").append((Object)this._remotePort).toString());
                    break;
                }
                case 103: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._serverPort, len);
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" server-port: ").append((Object)this._serverPort).toString());
                    break;
                }
                case 101: {
                    int len = (is.read() << 8) + is.read();
                    if (len <= 0) continue block24;
                    this._uri.add(63);
                    this._uri.ensureCapacity(this._uri.getLength() + len);
                    this._rawRead.readAll(this._uri.getBuffer(), this._uri.getLength(), len);
                    this._uri.setLength(this._uri.getLength() + len);
                    break;
                }
                case 99: {
                    int len = (is.read() << 8) + is.read();
                    this._rawRead.readAll(this._protocol, len);
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" protocol: ").append((Object)this._protocol).toString());
                    }
                    int i = 0;
                    while (true) {
                        if (i >= len) continue block24;
                        char ch = this._protocol.charAt(i);
                        if (ch >= '0' && ch <= '9') {
                            this._version = 16 * this._version + ch - 48;
                        } else if (ch == '.') {
                            this._version = 16 * this._version;
                        }
                        ++i;
                    }
                }
                case 72: {
                    int len = (is.read() << 8) + is.read();
                    int headerSize = this._headerSize;
                    CharBuffer key = this._headerKeys[headerSize];
                    key.clear();
                    CharBuffer valueCb = this._headerValues[headerSize];
                    valueCb.clear();
                    this._rawRead.readAll(key, len);
                    code = this._rawRead.read();
                    if (code != 83) {
                        throw new IOException(new StringBuffer().append("protocol expected HMUX_STRING at ").append((char)code).toString());
                    }
                    this._rawRead.readAll(valueCb, this.readLength());
                    this.addHeaderInt(key.getBuffer(), 0, key.length(), valueCb);
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append("H ").append((Object)key).append("=").append((Object)valueCb).toString());
                    }
                    ++this._headerSize;
                    break;
                }
                case 112: {
                    int len = (is.read() << 8) + is.read();
                    if (this._headerKeys.length <= this._headerSize) {
                        this.resizeHeaders();
                    }
                    this._headerKeys[this._headerSize].clear();
                    this._headerKeys[this._headerSize].append("Content-Length");
                    this._headerValues[this._headerSize].clear();
                    this._rawRead.readAll(this._headerValues[this._headerSize], len);
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" content-length=").append((Object)this._headerValues[this._headerSize]).toString());
                    }
                    ++this._headerSize;
                    break;
                }
                case 113: {
                    int len = (is.read() << 8) + is.read();
                    if (this._headerKeys.length <= this._headerSize) {
                        this.resizeHeaders();
                    }
                    this._headerKeys[this._headerSize].clear();
                    this._headerKeys[this._headerSize].append("Content-Type");
                    this._headerValues[this._headerSize].clear();
                    this._rawRead.readAll(this._headerValues[this._headerSize], len);
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" content-type=").append((Object)this._headerValues[this._headerSize]).toString());
                    }
                    ++this._headerSize;
                    break;
                }
                case 114: {
                    int len = (is.read() << 8) + is.read();
                    this._isSecure = true;
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append("secure").toString());
                    }
                    this._rawRead.skip(len);
                    break;
                }
                case 116: {
                    int len = (is.read() << 8) + is.read();
                    this._clientCert.clear();
                    this._clientCert.setLength(len);
                    this._rawRead.readAll(this._clientCert.getBuffer(), 0, len);
                    if (!isLoggable) continue block24;
                    log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" cert=").append(this._clientCert).append(" len:").append(len).toString());
                    break;
                }
                case 117: {
                    int len = (is.read() << 8) + is.read();
                    this._cb1.clear();
                    this._rawRead.readAll(this._cb1, len);
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" server=").append((Object)this._cb1).toString());
                    }
                    if (this._cb1.length() <= 0) continue block24;
                    this._serverType = this._cb1.charAt(0);
                    break;
                }
                case 100: {
                    int len = (is.read() << 8) + is.read();
                    this._cb.clear();
                    this._rawRead.readAll(this._cb, len);
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)this._cb).toString());
                    }
                    this.setAttribute("com.caucho.servlet.login.name", new BasicPrincipal(this._cb.toString()));
                    break;
                }
                case 68: {
                    int len;
                    this._pendingData = len = (is.read() << 8) + is.read();
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" post-data: ").append(len).toString());
                    }
                    return hasURI;
                }
                default: {
                    int len = (is.read() << 8) + is.read();
                    if (isLoggable) {
                        log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" ").append(len).toString());
                    }
                    is.skip(len);
                }
            }
        }
    }

    private void resizeHeaders() {
        int i;
        CharBuffer[] newKeys = new CharBuffer[this._headerSize * 2];
        CharBuffer[] newValues = new CharBuffer[this._headerSize * 2];
        for (i = 0; i < this._headerSize; ++i) {
            newKeys[i] = this._headerKeys[i];
            newValues[i] = this._headerValues[i];
        }
        for (i = this._headerSize; i < newKeys.length; ++i) {
            newKeys[i] = new CharBuffer();
            newValues[i] = new CharBuffer();
        }
        this._headerKeys = newKeys;
        this._headerValues = newValues;
    }

    private int readLength() throws IOException {
        return (this._rawRead.read() << 8) + this._rawRead.read();
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this._methodString = cb.equals(_getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this._methodString = cb.equals(_headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this._methodString = cb.equals(_postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this._methodString = cb.toString();
                }
            }
        }
        return this._methodString;
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    @Override
    protected CharBuffer getHost() {
        if (this._host.length() > 0) {
            return this._host;
        }
        this._host.append(this._serverName);
        this._host.toLowerCase();
        return this._host;
    }

    @Override
    public final byte[] getUriBuffer() {
        return this._uri.getBuffer();
    }

    @Override
    public final int getUriLength() {
        return this._uri.getLength();
    }

    @Override
    public String getProtocol() {
        return this._protocol.toString();
    }

    public CharSegment getProtocolBuffer() {
        return this._protocol;
    }

    final int getVersion() {
        return this._version;
    }

    @Override
    public boolean isSecure() {
        return this._isSecure;
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        for (int i = 0; i < this._headerSize; ++i) {
            CharBuffer test = this._headerKeys[i];
            if (!test.equalsIgnoreCase(key)) continue;
            return this._headerValues[i];
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] buf, int length) {
        for (int i = 0; i < this._headerSize; ++i) {
            int j;
            CharBuffer test = this._headerKeys[i];
            if (test.length() != length) continue;
            char[] keyBuf = test.getBuffer();
            for (j = 0; j < length; ++j) {
                char a = buf[j];
                char b = keyBuf[j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j != length) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void setHeader(String key, String value) {
        if (this._headerKeys.length <= this._headerSize) {
            this.resizeHeaders();
        }
        this._headerKeys[this._headerSize].clear();
        this._headerKeys[this._headerSize].append(key);
        this._headerValues[this._headerSize].clear();
        this._headerValues[this._headerSize].append(value);
        ++this._headerSize;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        CharBuffer cb = this._cb;
        cb.clear();
        cb.append(key);
        int size = this._headerSize;
        for (int i = 0; i < size; ++i) {
            CharBuffer test = this._headerKeys[i];
            if (!test.equalsIgnoreCase(cb)) continue;
            values.add(this._headerValues[i]);
        }
    }

    @Override
    public Enumeration getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            names.add(this._headerKeys[i].toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public String getRequestURI() {
        if (this._serverType == 82) {
            return super.getRequestURI();
        }
        String _rawURI = super.getRequestURI();
        CharBuffer cb = CharBuffer.allocate();
        block3: for (int i = 0; i < _rawURI.length(); ++i) {
            char ch = _rawURI.charAt(i);
            switch (ch) {
                case ' ': 
                case '?': {
                    this.addHex(cb, ch);
                    continue block3;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.close();
    }

    private void addHex(CharBuffer cb, int ch) {
        cb.append('%');
        int d = ch >> 4 & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
        d = ch & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
    }

    @Override
    public String getServerName() {
        CharBuffer host = this.getHost();
        if (host == null) {
            InetAddress addr = this.getConnection().getRemoteAddress();
            return addr.getHostName();
        }
        int p = host.indexOf(':');
        if (p >= 0) {
            return host.substring(0, p);
        }
        return host.toString();
    }

    @Override
    public int getServerPort() {
        int len = this._serverPort.length();
        int port = 0;
        for (int i = 0; i < len; ++i) {
            char ch = this._serverPort.charAt(i);
            port = 10 * port + ch - 48;
        }
        return port;
    }

    @Override
    public String getRemoteAddr() {
        return this._remoteAddr.toString();
    }

    public void getRemoteAddr(CharBuffer cb) {
        cb.append(this._remoteAddr);
    }

    @Override
    public String getRemoteHost() {
        return this._remoteHost.toString();
    }

    void writeStatus(CharBuffer message) throws IOException {
        int channel = 2;
        WriteStream os = this._rawWrite;
        os.write(67);
        os.write(channel >> 8);
        os.write(channel);
        this.writeString(115, message);
    }

    void sendHeader() throws IOException {
        this.writeString(71, "");
    }

    void writeHeader(String key, String value) throws IOException {
        this.writeString(72, key);
        this.writeString(83, value);
    }

    void writeHeader(String key, CharBuffer value) throws IOException {
        this.writeString(72, key);
        this.writeString(83, value);
    }

    void writeString(int code, String value) throws IOException {
        int len = value.length();
        WriteStream os = this._rawWrite;
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(value);
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" ").append(value).toString());
        }
    }

    void writeString(int code, CharBuffer cb) throws IOException {
        int len = cb.length();
        WriteStream os = this._rawWrite;
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(cb.getBuffer(), 0, len);
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append(this.dbgId()).append((char)code).append(" ").append((Object)cb).toString());
        }
    }

    String dbgId() {
        String id = this._server.getServerId();
        if (id.equals("")) {
            return new StringBuffer().append("[").append(this.getConnection().getId()).append("] ").toString();
        }
        return new StringBuffer().append("[").append(id).append(":").append(this.getConnection().getId()).append("] ").toString();
    }

    static class ServletFilter
    extends StreamImpl {
        HmuxRequest _request;
        ReadStream _is;
        WriteStream _os;
        byte[] _buffer = new byte[16];
        int _pendingData;
        boolean _needsAck;
        boolean _isClosed;
        boolean _isClientClosed;

        ServletFilter() {
        }

        void init(HmuxRequest request, ReadStream nextRead, WriteStream nextWrite) {
            this._request = request;
            this._is = nextRead;
            this._os = nextWrite;
            this._pendingData = 0;
            this._isClosed = false;
            this._isClientClosed = false;
            this._needsAck = false;
        }

        void setPending(int pendingData) {
            this._pendingData = pendingData;
        }

        void setClientClosed(boolean isClientClosed) {
            this._isClientClosed = isClientClosed;
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() {
            return this._pendingData;
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            int sublen = this._pendingData;
            ReadStream is = this._is;
            if (sublen <= 0) {
                return -1;
            }
            if (length < sublen) {
                sublen = length;
            }
            int readLen = is.read(buf, offset, sublen);
            this._pendingData -= readLen;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(new String(buf, offset, readLen));
            }
            while (this._pendingData == 0) {
                int len;
                if (this._needsAck) {
                    int channel = 2;
                    this._os.write(65);
                    this._os.write(channel >> 8);
                    this._os.write(channel);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this._request.dbgId() + "A:ack channel 2");
                    }
                }
                this._needsAck = false;
                int code = is.read();
                if (code == 68) {
                    len = (is.read() << 8) + is.read();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this._request.dbgId() + "D:post-data " + len);
                    }
                    this._pendingData = len;
                    continue;
                }
                if (code == 81) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this._request.dbgId() + "Q:quit");
                    }
                    return readLen;
                }
                if (code == 88) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this._request.dbgId() + "X:exit");
                    }
                    this._request.killKeepalive();
                    return readLen;
                }
                if (code == 89) {
                    this._needsAck = true;
                    continue;
                }
                if (code == 67) {
                    int channel = (is.read() << 8) + is.read();
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine(this._request.dbgId() + "channel " + channel);
                    continue;
                }
                if (code < 0) {
                    this._request.killKeepalive();
                    return readLen;
                }
                this._request.killKeepalive();
                len = (is.read() << 8) + is.read();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this._request.dbgId() + "unknown `" + (char)code + "' " + len);
                }
                is.skip(len);
            }
            return readLen;
        }

        public boolean canWrite() {
            return true;
        }

        public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
            length -= 3;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._request.dbgId() + 'D' + ":data " + length);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this._request.dbgId() + "data <" + new String(buf, 3, length) + ">");
                }
            }
            buf[0] = 68;
            buf[1] = (byte)(length >> 8);
            buf[2] = (byte)length;
            this._os.write(buf, offset, length + 3);
        }

        public void flush() throws IOException {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._request.dbgId() + 'f' + ":flush");
            }
            this._os.write(102);
            this._os.write(0);
            this._os.write(0);
            this._os.flush();
        }

        public void close() throws IOException {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            if (this._pendingData > 0) {
                this._is.skip(this._pendingData);
                this._pendingData = 0;
            }
            if (!this._isClientClosed) {
                if (log.isLoggable(Level.FINE)) {
                    if (this._request.allowKeepalive()) {
                        log.fine(this._request.dbgId() + 'Q' + ": quit channel");
                    } else {
                        log.fine(this._request.dbgId() + 'X' + ": exit socket");
                    }
                }
                if (this._request.allowKeepalive()) {
                    this._os.write(81);
                } else {
                    this._os.write(88);
                }
            }
            if (this._request.allowKeepalive()) {
                this._os.flush();
            } else {
                this._os.close();
            }
        }
    }
}

