/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.ConfigException;
import com.caucho.config.NodeBuilder;
import com.caucho.config.types.EjbRef;
import com.caucho.ejb.AbstractStubLoader;
import com.caucho.java.WorkDir;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.server.e_app.AppClientBinding;
import com.caucho.server.e_app.AppClientConfig;
import com.caucho.server.e_app.AppClientEntry;
import com.caucho.server.e_app.ApplicationConfig;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class EntAppClient
implements DeployInstance,
EnvironmentBean {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/e_app/EntAppClient"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/e_app/EntAppClient"));
    private EnvironmentClassLoader _loader;
    private String _name;
    private Path _rootDir;
    private Path _archivePath;
    private String _mainClass;
    private String _prefix = "";
    private AppClientEntry _entry;
    private AbstractStubLoader _stubLoader;
    private ApplicationConfig _config;
    private AppClientConfig _appClientConfig;
    private HashMap<String, EjbRef> _ejbRefMap = new HashMap();
    private Throwable _configException;
    private Alarm _alarm;
    private final Lifecycle _lifecycle;

    EntAppClient(AppClientEntry entry, String name) {
        this._entry = entry;
        this._name = name;
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        this._loader = new EnvironmentClassLoader(parentLoader);
        this._loader.setId("EntAppClient[" + name + "]");
        this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
        if (entry.getArchivePath() != null) {
            Environment.addDependency(new Depend(entry.getArchivePath()), (ClassLoader)this._loader);
        }
    }

    public void setName(String name) {
        this._name = name;
        this._loader.setId("EntAppClient[" + name + "]");
    }

    public String getName() {
        return this._name;
    }

    public void setRootDirectory(Path rootDir) {
        this._rootDir = rootDir;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setArchivePath(Path archivePath) {
        this._archivePath = archivePath;
    }

    public void setDescription(String description) {
    }

    public void setDisplayName(String displayName) {
    }

    public void addEjbRef(EjbRef ejbRef) {
        this._ejbRefMap.put(ejbRef.getEjbRefName(), ejbRef);
        this.addIiopStub(ejbRef.getHome());
        this.addIiopStub(ejbRef.getRemote());
    }

    private void addIiopStub(Class stubClass) {
        if (stubClass == null) {
            return;
        }
        try {
            if (this._stubLoader == null) {
                Class<?> iiopClass = Class.forName("com.caucho.iiop.IiopStubLoader");
                this._stubLoader = (AbstractStubLoader)iiopClass.newInstance();
                this._stubLoader.setPath(WorkDir.getLocalWorkDir());
                this._loader.addLoader(this._stubLoader);
            }
            this._stubLoader.addStubClass(stubClass.getName());
        }
        catch (Throwable e) {
            log.info(e.toString());
        }
    }

    Class getEjbHome(String ejbName) {
        EjbRef ejbRef = this._ejbRefMap.get(ejbName);
        if (ejbRef != null) {
            return ejbRef.getHome();
        }
        return null;
    }

    public void setMainClass(String mainClass) {
        this._mainClass = mainClass;
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._loader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._loader = loader;
    }

    public void setConfigException(Throwable e) {
        this._configException = e;
    }

    public Throwable getConfigException() {
        return this._configException;
    }

    public EjbLink createEjbLink() {
        return new EjbLink();
    }

    public void setSchemaLocation(String s) {
    }

    public void setVersion(String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (!this._lifecycle.toInit()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            Path rootDir = this.getRootDirectory();
            Vfs.setPwd(rootDir);
            Path workDir = this.getRootDirectory().lookup("META-INF/work");
            this._loader.addJar(workDir);
            WorkDir.setLocalWorkDir(workDir);
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.log(Level.WARNING, e.toString(), e);
            this._configException = e;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void configResinBinding() throws Exception {
        Path rootDir = this.getRootDirectory();
        Path xml = rootDir.lookup("META-INF/resin-client.xml");
        if (!xml.canRead()) {
            return;
        }
        AppClientBinding binding = new AppClientBinding(this);
        NodeBuilder builder = new NodeBuilder();
        builder.configure((Object)binding, xml);
    }

    public boolean isModified() {
        return false;
    }

    public boolean isModifiedForAutomaticRedeploy() {
        return this.isModified();
    }

    public void start() {
        this.init();
        if (!this._lifecycle.toActive()) {
            return;
        }
    }

    public void main(String[] args) throws Throwable {
        if (this._mainClass == null) {
            throw new IllegalStateException(L.l("main() method require a main class"));
        }
        this.main(this._mainClass, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(String mainClassName, String[] args) throws Throwable {
        this.start();
        if (this._configException != null) {
            throw this._configException;
        }
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("{0} is not active.", this));
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            Class<?> mainClass = Class.forName(mainClassName, false, this._loader);
            Method main = mainClass.getMethod("main", ClassLiteral.getClass((String)"[Ljava/lang/String;"));
            main.invoke(null, new Object[]{args});
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
    }

    public String toString() {
        return "EntAppClient[" + this.getName() + "]";
    }

    public class EjbLink {
        private String _ejbName;
        private String _jndiName;
        private Class _api;

        public void setEjbName(String ejbName) throws ConfigException {
            this._ejbName = ejbName;
            this._api = EntAppClient.this.getEjbHome(this._ejbName);
            if (this._api == null) {
                throw new ConfigException(L.l("'{0}' is an unknown ejb name.", ejbName));
            }
        }

        public void setJndiName(String jndiName) {
            this._jndiName = jndiName;
        }

        public void init() throws Exception {
            String orbHost = System.getProperty("org.omg.CORBA.ORBInitialHost");
            String orbPort = System.getProperty("org.omg.CORBA.ORBInitialPort");
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            env.put("java.naming.provider.url", "iiop://" + orbHost + ":" + orbPort);
            InitialContext ic = new InitialContext(env);
            Object ior = ic.lookup(this._jndiName);
            Object value = PortableRemoteObject.narrow((Object)ior, (Class)this._api);
            System.out.println("VALUE: " + value + " " + value.getClass() + " " + this._api);
            Jndi.rebindDeepShort(this._ejbName, value);
        }
    }
}

