/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.make.CachedDependency;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployList;
import com.caucho.server.deploy.Entry;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployContainer<E extends Entry>
extends CachedDependency
implements Dependency {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/deploy/DeployContainer"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/deploy/DeployContainer"));
    private DeployList<E> _deployList = new DeployList(this);
    private ArrayList<E> _entryList = new ArrayList();
    private long _redeployInterval = 60000L;
    private final Lifecycle _lifecycle = new Lifecycle();

    public DeployContainer() {
        this.setCheckInterval(Environment.getDependencyCheckInterval());
    }

    public void add(Deploy<E> deploy) {
        TreeSet<String> names = new TreeSet<String>();
        deploy.fillDeployedKeys(names);
        this._deployList.add(deploy);
        this.update(names);
    }

    public void remove(Deploy<E> deploy) {
        TreeSet<String> names = new TreeSet<String>();
        deploy.fillDeployedKeys(names);
        this._deployList.remove(deploy);
        this.update(names);
    }

    @Override
    public boolean isModifiedImpl() {
        return this._deployList.isModified();
    }

    public void update() {
        this._deployList.update();
    }

    public void redeployIfModified() {
        this._deployList.redeployIfModified();
    }

    public void init() {
        if (!this._lifecycle.toInit()) {
            return;
        }
    }

    public void start() {
        this.init();
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._deployList.start();
        for (int i = 0; i < this._entryList.size(); ++i) {
            Entry entry = (Entry)this._entryList.get(i);
            entry.startAutomatic();
        }
    }

    public E findEntry(String name) {
        E entry = this.findDeployedEntry(name);
        if (entry != null) {
            return entry;
        }
        return this.generateEntry(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<E> getEntries() {
        ArrayList<E> list = new ArrayList<E>();
        ArrayList<E> arrayList = this._entryList;
        synchronized (arrayList) {
            list.addAll(this._entryList);
        }
        return list;
    }

    private void update(Set<String> names) {
        for (String name : names) {
            this.update(name);
        }
    }

    public E update(String name) {
        E newEntry = this.updateImpl(name);
        if (this._lifecycle.isActive() && newEntry != null) {
            ((Entry)newEntry).startAutomatic();
        }
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    E updateImpl(String name) {
        Entry oldEntry = null;
        ArrayList<E> arrayList = this._entryList;
        synchronized (arrayList) {
            oldEntry = (Entry)this.findDeployedEntry(name);
        }
        E newEntry = this._deployList.generateEntry(name);
        if (oldEntry != null && oldEntry != newEntry) {
            if (oldEntry != null) {
                this._entryList.remove(oldEntry);
            }
            oldEntry.destroy();
        }
        if (newEntry != null && !this._entryList.contains(newEntry)) {
            ((Entry)newEntry).setDeployContainer(this);
            this._entryList.add(newEntry);
            this.init(newEntry);
        }
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        Entry oldEntry = null;
        ArrayList<E> arrayList = this._entryList;
        synchronized (arrayList) {
            oldEntry = (Entry)this.findDeployedEntry(name);
            if (oldEntry != null) {
                this._entryList.remove(oldEntry);
            }
        }
        if (oldEntry != null) {
            oldEntry.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E generateEntry(String name) {
        E newEntry = this._deployList.generateEntry(name);
        if (newEntry == null) {
            return null;
        }
        ArrayList<E> arrayList = this._entryList;
        synchronized (arrayList) {
            E entry = this.findDeployedEntry(name);
            if (entry != null) {
                return entry;
            }
            ((Entry)newEntry).setDeployContainer(this);
            this._entryList.add(newEntry);
        }
        this.init(newEntry);
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(E entry) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(((Entry)entry).getParentClassLoader());
            ((Entry)entry).init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E findDeployedEntry(String name) {
        ArrayList<E> arrayList = this._entryList;
        synchronized (arrayList) {
            for (int i = 0; i < this._entryList.size(); ++i) {
                Entry entry = (Entry)this._entryList.get(i);
                if (!entry.isNameMatch(name)) continue;
                return (E)entry;
            }
        }
        return null;
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        ArrayList<E> entries = new ArrayList<E>(this._entryList);
        for (int i = 0; i < entries.size(); ++i) {
            ((Entry)entries.get(i)).stop();
        }
    }

    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._deployList.destroy();
        this._entryList.clear();
    }

    public String toString() {
        return new StringBuffer().append("DeployContainer$").append(System.identityHashCode(this)).append("[]").toString();
    }
}

